/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextFieldEditableSupport {
    private StyledText m_styledText;
    private Text m_text;
    private Control[] m_tabListBackup;
    private Listener m_readOnlyListener;
    private final Object m_lock = new Object();
    private boolean m_editable;

    public TextFieldEditableSupport(StyledText styledText) {
        this.m_styledText = styledText;
        this.m_editable = true;
    }

    public TextFieldEditableSupport(Text text) {
        this.m_text = text;
        this.m_editable = true;
    }

    public Control getTextField() {
        if (this.m_styledText != null) {
            return this.m_styledText;
        }
        if (this.m_text != null) {
            return this.m_text;
        }
        throw new IllegalStateException("StyledText and Text is null");
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditable(boolean editable) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_editable != editable) {
                if (editable) {
                    if (this.m_readOnlyListener != null) {
                        this.getTextField().removeListener(15, this.m_readOnlyListener);
                        this.getTextField().removeListener(16, this.m_readOnlyListener);
                        this.m_readOnlyListener = null;
                    }
                } else if (this.m_readOnlyListener == null) {
                    this.m_readOnlyListener = new P_ReadOnlyListener();
                    this.getTextField().addListener(15, this.m_readOnlyListener);
                    this.getTextField().addListener(16, this.m_readOnlyListener);
                }
                this.setEditableInternal(editable);
                this.setFieldInTabList(editable);
                this.m_editable = editable;
            }
        }
    }

    private void setEditableInternal(boolean editable) {
        if (this.m_styledText != null) {
            this.m_styledText.setEditable(editable);
        } else if (this.m_text != null) {
            this.m_text.setEditable(editable);
        }
    }

    private void setFieldInTabList(boolean inTablist) {
        Control textField = this.getTextField();
        Composite parent = textField.getParent();
        if (inTablist) {
            if (this.m_tabListBackup == null) {
                return;
            }
            parent.setTabList(this.m_tabListBackup);
            this.m_tabListBackup = null;
        } else {
            if (this.m_tabListBackup != null) {
                return;
            }
            this.m_tabListBackup = parent.getTabList();
            ArrayList<Control> tabList = new ArrayList<Control>(Arrays.asList(this.m_tabListBackup));
            if (tabList.remove(textField)) {
                parent.setTabList(tabList.toArray(new Control[tabList.size()]));
            }
        }
    }

    private class P_ReadOnlyListener
    implements Listener {
        private P_ReadOnlyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event event) {
            Object object = TextFieldEditableSupport.this.m_lock;
            synchronized (object) {
                switch (event.type) {
                    case 15: {
                        TextFieldEditableSupport.this.setFieldInTabList(true);
                        break;
                    }
                    case 16: {
                        TextFieldEditableSupport.this.setFieldInTabList(false);
                    }
                }
            }
        }
    }
}

