/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.popup;

import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartEvent;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Form;

public class SwtScoutPopup
implements ISwtScoutPart {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutPopup.class);
    public static final String PROP_POPUP_OWNER = "propPopupOwner";
    private ISwtEnvironment m_env;
    private Control m_ownerComponent;
    private Rectangle m_ownerBounds;
    private Shell m_swtWindow;
    private Composite m_swtWindowContentPane;
    private EventListenerList m_listenerList;
    private IForm m_scoutForm;
    private boolean m_positionBelowReferenceField;
    private boolean m_opened;
    private boolean m_popupOnField;
    private int m_widthHint;
    private int m_heightHint;
    private int m_maxHeightHint;
    private int m_maxWidthHint;
    private ISwtScoutForm m_uiForm;

    public SwtScoutPopup(ISwtEnvironment env, Control ownerComponent, Rectangle ownerBounds, int style) {
        this.m_env = env;
        this.m_positionBelowReferenceField = true;
        this.m_ownerComponent = ownerComponent;
        this.m_ownerBounds = ownerBounds;
        this.m_listenerList = new EventListenerList();
        this.m_widthHint = -1;
        this.m_heightHint = -1;
        this.m_maxHeightHint = -1;
        this.m_maxWidthHint = -1;
        this.m_swtWindow = new Shell(ownerComponent.getShell(), style);
        this.m_swtWindow.setData("extendedStyle", (Object)8);
        this.m_swtWindow.setLayout((Layout)new FillLayout());
        this.m_swtWindow.addDisposeListener((DisposeListener)new P_SwtWindowDisposeListener());
        this.m_swtWindowContentPane = env.getFormToolkit().createComposite((Composite)this.m_swtWindow, 0);
        this.m_swtWindowContentPane.setLayout((Layout)new FillLayout());
    }

    @Override
    public void setBusy(boolean b) {
    }

    public Shell getShell() {
        return this.m_swtWindow;
    }

    public void setBounds(Rectangle bounds) {
        this.getShell().setBounds(bounds);
        this.getShell().layout(true, true);
    }

    public boolean isPopupOnField() {
        return this.m_popupOnField;
    }

    public void setPopupOnField(boolean popupOnField) {
        this.m_popupOnField = popupOnField;
    }

    public boolean isPopupBelow() {
        return this.m_positionBelowReferenceField;
    }

    public int getWidthHint() {
        return this.m_widthHint;
    }

    public void setWidthHint(int widthHint) {
        this.m_widthHint = widthHint > 0 ? widthHint : -1;
    }

    public int getHeightHint() {
        return this.m_heightHint;
    }

    public void setHeightHint(int heightHint) {
        this.m_heightHint = heightHint > 0 ? heightHint : -1;
    }

    public int getMaxHeightHint() {
        return this.m_maxHeightHint;
    }

    public void setMaxHeightHint(int maxHeightHint) {
        this.m_maxHeightHint = maxHeightHint > 0 ? maxHeightHint : -1;
    }

    public int getMaxWidthHint() {
        return this.m_maxWidthHint;
    }

    public void setMaxWidthHint(int maxWidthHint) {
        this.m_maxWidthHint = maxWidthHint > 0 ? maxWidthHint : -1;
    }

    public void showForm(IForm scoutForm) throws ProcessingException {
        this.m_opened = true;
        if (this.m_scoutForm == null) {
            this.m_scoutForm = scoutForm;
            this.m_uiForm = this.m_env.createForm(this.getSwtContentPane(), scoutForm);
            this.autoAdjustBounds();
            if (this.m_opened) {
                this.handleSwtWindowOpening();
                this.m_swtWindow.open();
                this.autoAdjustBounds();
                if (this.m_opened) {
                    this.handleSwtWindowOpened();
                }
            }
        } else {
            throw new ProcessingException("The popup is already open. The form '" + scoutForm.getTitle() + " (" + scoutForm.getClass().getName() + ")' can not be opened!");
        }
    }

    @Override
    public void closePart() {
        this.m_opened = false;
        try {
            if (!this.m_swtWindow.isDisposed()) {
                this.m_swtWindow.setVisible(false);
                this.m_swtWindow.dispose();
            }
        }
        catch (Throwable t) {
            LOG.error("Failed closing popup for " + this.m_scoutForm, t);
        }
    }

    @Override
    public IForm getForm() {
        return this.m_scoutForm;
    }

    @Override
    public Form getSwtForm() {
        return null;
    }

    @Override
    public ISwtScoutForm getUiForm() {
        return this.m_uiForm;
    }

    public void autoAdjustBounds() {
        Rectangle alternateView;
        if (this.getShell().isDisposed()) {
            return;
        }
        if (this.m_ownerComponent.isDisposed()) {
            LOG.warn("Unexpected: Owner component of popup is disposed");
            return;
        }
        Point dim = this.getShell().computeSize(this.m_widthHint, this.m_heightHint, true);
        dim.x = Math.max(dim.x, UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutDefaultColumnWidth());
        if (this.m_maxWidthHint != -1) {
            dim.x = Math.min(dim.x, this.m_maxWidthHint);
        }
        if (this.m_maxHeightHint != -1) {
            dim.y = Math.min(dim.y, this.m_maxHeightHint);
        }
        Point p = this.m_ownerComponent.toDisplay(new Point(-this.m_ownerComponent.getBorderWidth(), 0));
        Point above = new Point(p.x, p.y);
        if (this.m_popupOnField) {
            above.y += this.m_ownerComponent.getBounds().height;
        }
        Rectangle aboveView = SwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(above.x, above.y - dim.y, dim.x, dim.y), false, false);
        Point below = new Point(p.x, p.y);
        if (!this.m_popupOnField) {
            below.y += this.m_ownerComponent.getBounds().height;
        }
        Rectangle belowView = SwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(below.x, below.y, dim.x, dim.y), false, false);
        Rectangle currentView = this.m_positionBelowReferenceField ? belowView : aboveView;
        Rectangle rectangle = alternateView = this.m_positionBelowReferenceField ? aboveView : belowView;
        if (currentView.height >= alternateView.height) {
            this.getShell().setBounds(currentView);
        } else {
            this.getShell().setBounds(alternateView);
            this.m_positionBelowReferenceField = !this.m_positionBelowReferenceField;
        }
    }

    public Composite getSwtContentPane() {
        return this.m_swtWindowContentPane;
    }

    public void addSwtScoutPartListener(SwtScoutPartListener listener) {
        this.m_listenerList.add(SwtScoutPartListener.class, (EventListener)listener);
    }

    public void removeSwtScoutPartListener(SwtScoutPartListener listener) {
        this.m_listenerList.remove(SwtScoutPartListener.class, (EventListener)listener);
    }

    protected void fireSwtScoutPartEvent(SwtScoutPartEvent e) {
        EventListener[] listeners;
        if (this.m_swtWindow != null && (listeners = this.m_listenerList.getListeners(SwtScoutPartListener.class)) != null && listeners.length > 0) {
            EventListener[] eventListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                EventListener listener = eventListenerArray[n2];
                try {
                    ((SwtScoutPartListener)listener).partChanged(e);
                }
                catch (Throwable t) {
                    LOG.error("Unexpected:", t);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_swtWindow != null && this.m_swtWindow.getVisible();
    }

    @Override
    public void activate() {
        this.m_swtWindow.getShell().setActive();
    }

    @Override
    public boolean isActive() {
        return this.m_swtWindow != null && this.m_swtWindow.getDisplay().getActiveShell() == this.m_swtWindow;
    }

    @Override
    public void setStatusLineMessage(Image image, String message) {
    }

    protected void handleSwtWindowOpening() {
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 10));
    }

    protected void handleSwtWindowOpened() {
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 20));
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 30));
    }

    protected Control getOwnerComponent() {
        return this.m_ownerComponent;
    }

    protected void handleSwtWindowClosed() {
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 50));
        Runnable job = new Runnable(){

            @Override
            public void run() {
                SwtScoutPopup.this.m_scoutForm.getUIFacade().fireFormKilledFromUI();
            }
        };
        this.m_env.invokeScoutLater(job, 0L);
    }

    private class P_SwtWindowDisposeListener
    implements DisposeListener {
        private P_SwtWindowDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            SwtScoutPopup.this.handleSwtWindowClosed();
        }
    }
}

