/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import org.eclipse.scout.rt.ui.swt.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SwtShellValidateRoot
extends DefaultValidateRoot {
    ISwtEnvironment m_env;

    public SwtShellValidateRoot(Shell root, ISwtEnvironment env) {
        super((Composite)root);
        if (env == null) {
            throw new IllegalArgumentException("environment cannot be null.");
        }
        this.m_env = env;
    }

    private Shell getShell() {
        return (Shell)this.getComposite();
    }

    protected ISwtEnvironment getEnvironment() {
        return this.m_env;
    }

    protected boolean isActive() {
        return this.getShell() == this.getEnvironment().getDisplay().getActiveShell();
    }

    @Override
    public void validate() {
        if (this.getShell() == null || this.getShell().isDisposed() || !this.getShell().isVisible() || !this.isActive()) {
            return;
        }
        super.validate();
        Rectangle curShellBounds = this.getShell().getBounds();
        Point prefSize = this.getShell().computeSize(-1, -1, true);
        int dhPref = 0;
        if (curShellBounds != null && prefSize != null && (dhPref = prefSize.y - curShellBounds.height) > 0) {
            this.getShell().setBounds(new Rectangle(curShellBounds.x, curShellBounds.y, curShellBounds.width, prefSize.y));
        }
    }
}

