/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.basic.ISwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStrokeFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class SwtScoutComposite<T extends IPropertyObserver>
implements ISwtScoutComposite<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutComposite.class);
    protected static final String CLIENT_PROP_INITIAL_OPAQUE = "scoutInitialOpaque";
    protected static final String CLIENT_PROP_INITIAL_FONT = "scoutInitialFont";
    protected static final String CLIENT_PROP_INITIAL_BACKGROUND = "scoutInitialBackground";
    protected static final String CLIENT_PROP_INITIAL_FOREGROUND = "scoutInitialForeground";
    private Composite m_swtContainer;
    private Control m_swtField;
    private final OptimisticLock m_updateSwtFromScoutLock = new OptimisticLock();
    private final Set<String> m_ignoredScoutEvents = new HashSet<String>();
    private T m_scoutObject;
    private P_ScoutPropertyChangeListener m_scoutPropertyListener;
    private boolean m_connectedToScout;
    private ISwtEnvironment m_environment;
    private boolean m_initialized;

    public static void registerCompositeOnWidget(Widget comp, ISwtScoutComposite ui) {
        if (comp != null) {
            comp.setData("ISwtScoutComposite", new WeakReference<ISwtScoutComposite>(ui));
        }
    }

    public static ISwtScoutComposite getCompositeOnWidget(Widget comp) {
        if (comp instanceof Widget) {
            WeakReference ref = (WeakReference)comp.getData("ISwtScoutComposite");
            return ref != null ? (ISwtScoutComposite)ref.get() : null;
        }
        return null;
    }

    public static IPropertyObserver getScoutModelOnWidget(Widget comp) {
        ISwtScoutComposite ui = SwtScoutComposite.getCompositeOnWidget(comp);
        if (ui != null) {
            return ui.getScoutObject();
        }
        return null;
    }

    public OptimisticLock getUpdateSwtFromScoutLock() {
        return this.m_updateSwtFromScoutLock;
    }

    public void addIgnoredScoutEvent(Class eventType, String name) {
        this.m_ignoredScoutEvents.add(String.valueOf(eventType.getSimpleName()) + ":" + name);
    }

    public void removeIgnoredScoutEvent(Class eventType, String name) {
        this.m_ignoredScoutEvents.remove(String.valueOf(eventType.getSimpleName()) + ":" + name);
    }

    public boolean isIgnoredScoutEvent(Class eventType, String name) {
        if (this.m_ignoredScoutEvents.isEmpty()) {
            return false;
        }
        boolean b = this.m_ignoredScoutEvents.contains(String.valueOf(eventType.getSimpleName()) + ":" + name);
        return b;
    }

    @Override
    public void createField(Composite parent, T scoutObject, ISwtEnvironment environment) {
        this.m_scoutObject = scoutObject;
        this.m_environment = environment;
        this.callInitializers(parent);
    }

    protected final void callInitializers(Composite parent) {
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
        try {
            this.initializeSwt(parent);
            if (this.getSwtContainer() != null && SwtScoutComposite.getCompositeOnWidget((Widget)this.getSwtContainer()) == null) {
                SwtScoutComposite.registerCompositeOnWidget((Widget)this.getSwtContainer(), this);
            }
            if (this.getSwtField() != null && SwtScoutComposite.getCompositeOnWidget((Widget)this.getSwtField()) == null) {
                SwtScoutComposite.registerCompositeOnWidget((Widget)this.getSwtField(), this);
            }
            this.connectToScout();
        }
        catch (Exception e) {
            this.m_initialized = false;
            LOG.error("could not initialize component '" + this.getScoutObject().getClass().getName() + "' to '" + this.getClass().getName() + "'.", (Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    @Override
    public Composite getSwtContainer() {
        return this.m_swtContainer;
    }

    protected void setSwtContainer(Composite swtContainer) {
        this.m_swtContainer = swtContainer;
        if (this.m_swtContainer != null) {
            P_SwtContainerListener listener = new P_SwtContainerListener();
            this.m_swtContainer.addListener(12, (Listener)listener);
        }
    }

    protected void initializeSwt(Composite parent) {
    }

    @Override
    public Control getSwtField() {
        return this.m_swtField;
    }

    protected void setSwtField(Control swtField) {
        this.m_swtField = swtField;
        if (this.m_swtField != null) {
            if (this.getScoutObject() instanceof IFormField && this.m_swtField.getLayoutData() == null) {
                this.m_swtField.setLayoutData((Object)LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
            }
            this.getEnvironment().addKeyStrokeFilter((Widget)swtField, new ISwtKeyStrokeFilter(){

                @Override
                public boolean accept(Event e, ISwtEnvironment environment) {
                    if (SwtScoutComposite.this.getEnvironment() != null && SwtScoutComposite.this.getEnvironment().equals(environment)) {
                        return SwtScoutComposite.this.filterKeyEvent(e);
                    }
                    return false;
                }
            });
            P_SwtFieldListener listener = new P_SwtFieldListener();
            this.m_swtField.addListener(15, (Listener)listener);
            this.m_swtField.addListener(16, (Listener)listener);
            this.m_swtField.addListener(31, (Listener)listener);
            this.m_swtField.addListener(25, (Listener)listener);
            this.m_swtField.addListener(12, (Listener)listener);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.getSwtContainer() == null || this.getSwtContainer().isDisposed();
    }

    protected boolean filterKeyEvent(Event e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            return this.handleSwtInputVerifier();
        }
        return true;
    }

    @Override
    public T getScoutObject() {
        return this.m_scoutObject;
    }

    public boolean isConnectedToScout() {
        return this.m_connectedToScout;
    }

    protected final void connectToScout() {
        if (!this.m_connectedToScout) {
            try {
                this.getUpdateSwtFromScoutLock().acquire();
                this.attachScout();
                this.applyScoutProperties();
                this.applyScoutState();
                this.m_connectedToScout = true;
            }
            finally {
                this.getUpdateSwtFromScoutLock().release();
            }
        }
    }

    @Override
    public final void dispose() {
        if (this.getSwtField() != null) {
            this.getSwtField().dispose();
        }
        if (this.getSwtContainer() != null) {
            this.getSwtContainer().dispose();
        }
        this.disconnectFromScout();
    }

    protected final void disconnectFromScout() {
        if (this.m_connectedToScout) {
            try {
                this.getUpdateSwtFromScoutLock().acquire();
                this.detachScout();
                this.m_connectedToScout = false;
            }
            finally {
                this.getUpdateSwtFromScoutLock().release();
            }
        }
    }

    protected void applyScoutProperties() {
    }

    protected void applyScoutState() {
    }

    protected void attachScout() {
        if (this.m_scoutObject != null) {
            if (this.m_swtContainer != null) {
                this.m_swtContainer.setData("org.eclipse.scout.rt.object", this.m_scoutObject);
            }
            if (this.m_scoutPropertyListener == null) {
                this.m_scoutPropertyListener = new P_ScoutPropertyChangeListener();
                this.m_scoutObject.addPropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
            }
        }
    }

    protected void detachScout() {
        if (this.m_scoutObject != null && this.m_scoutPropertyListener != null) {
            this.m_scoutObject.removePropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
            this.m_scoutPropertyListener = null;
        }
    }

    protected boolean isHandleScoutPropertyChange(String name, Object newValue) {
        return true;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
    }

    protected void handleSwtFocusGained() {
    }

    protected void handleSwtFocusLost() {
    }

    protected boolean handleSwtInputVerifier() {
        return true;
    }

    protected void handleSwtAddNotify() {
        this.connectToScout();
    }

    protected void handleSwtRemoveNotify() {
        this.disconnectFromScout();
    }

    @Override
    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    protected void debugHandlePropertyChanged(PropertyChangeEvent e) {
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            SwtScoutComposite.this.debugHandlePropertyChanged(e);
            if (SwtScoutComposite.this.isIgnoredScoutEvent(PropertyChangeEvent.class, e.getPropertyName())) {
                return;
            }
            if (SwtScoutComposite.this.isHandleScoutPropertyChange(e.getPropertyName(), e.getNewValue())) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (!SwtScoutComposite.this.isDisposed()) {
                            try {
                                SwtScoutComposite.this.getUpdateSwtFromScoutLock().acquire();
                                SwtScoutComposite.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                            }
                            finally {
                                SwtScoutComposite.this.getUpdateSwtFromScoutLock().release();
                            }
                        }
                    }
                };
                SwtScoutComposite.this.m_environment.invokeSwtLater(t);
            }
        }
    }

    private class P_SwtContainerListener
    implements Listener {
        private P_SwtContainerListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 12: {
                    SwtScoutComposite.this.handleSwtRemoveNotify();
                }
            }
        }
    }

    private class P_SwtFieldListener
    implements Listener {
        private long m_timestamp;

        private P_SwtFieldListener() {
        }

        public void handleEvent(Event event) {
            if (!event.doit) {
                return;
            }
            switch (event.type) {
                case 25: {
                    if (!event.text.equals("\t")) break;
                    event.doit = false;
                    break;
                }
                case 31: {
                    switch (event.keyCode) {
                        case 13: 
                        case 27: 
                        case 0x1000001: 
                        case 0x1000002: 
                        case 0x1000003: 
                        case 0x1000004: 
                        case 0x1000005: 
                        case 0x1000006: 
                        case 0x1000007: 
                        case 0x1000008: {
                            return;
                        }
                    }
                    this.m_timestamp = event.time;
                    event.doit = SwtScoutComposite.this.handleSwtInputVerifier();
                    break;
                }
                case 15: {
                    SwtScoutComposite.this.handleSwtFocusGained();
                    break;
                }
                case 16: {
                    if (SwtScoutComposite.this.getSwtField() != null && SwtScoutComposite.this.getSwtField().getDisplay().getActiveShell() != null && SwtScoutComposite.this.getSwtField().getShell() != SwtScoutComposite.this.getSwtField().getDisplay().getActiveShell()) {
                        return;
                    }
                    if (this.m_timestamp != (long)event.time) {
                        SwtScoutComposite.this.handleSwtInputVerifier();
                    }
                    SwtScoutComposite.this.handleSwtFocusLost();
                    break;
                }
                case 12: {
                    if (SwtScoutComposite.this.m_swtContainer != null) break;
                    SwtScoutComposite.this.handleSwtRemoveNotify();
                    break;
                }
            }
        }
    }
}

