/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutDndSupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableMouseMoveSelectionSupport {
    private Table m_table;
    private boolean m_mouseDown = false;
    private int m_selectionStartIndex;
    private ISwtScoutDndSupport m_dndSupport;
    private TableItem m_itemToSelect;
    private TableItem[] m_existingSelection;

    public TableMouseMoveSelectionSupport(Table table, ISwtScoutDndSupport dndSupport) {
        this.m_table = table;
        this.m_dndSupport = dndSupport;
        if ((this.m_table.getStyle() & 2) != 0) {
            this.m_table.addMouseListener((MouseListener)new P_MouseListener());
            this.m_table.addMouseMoveListener((MouseMoveListener)new P_MouseMoveListener());
            this.m_table.addMouseTrackListener((MouseTrackListener)new P_MouseTrackListener());
            this.m_table.addSelectionListener((SelectionListener)new P_SelectionListener());
        }
    }

    public Table getTable() {
        return this.m_table;
    }

    private void stopSelecting() {
        this.m_mouseDown = false;
        this.selectingStopped();
    }

    protected void selectingStopped() {
    }

    public boolean acceptDrag() {
        if (this.m_itemToSelect == null) {
            return true;
        }
        if (this.m_existingSelection != null) {
            TableItem[] tableItemArray = this.m_existingSelection;
            int n = this.m_existingSelection.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem selectedItem = tableItemArray[n2];
                if (selectedItem == this.m_itemToSelect) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private class P_MouseListener
    extends MouseAdapter {
        private P_MouseListener() {
        }

        public void mouseDown(MouseEvent event) {
            if (event.button != 1) {
                return;
            }
            TableMouseMoveSelectionSupport.this.m_mouseDown = true;
            TableMouseMoveSelectionSupport.this.m_selectionStartIndex = -1;
            TableItem item = TableMouseMoveSelectionSupport.this.getTable().getItem(new Point(event.x, event.y));
            if (item != null) {
                TableMouseMoveSelectionSupport.this.m_selectionStartIndex = TableMouseMoveSelectionSupport.this.getTable().indexOf(item);
            }
        }

        public void mouseUp(MouseEvent e) {
            TableMouseMoveSelectionSupport.this.stopSelecting();
        }
    }

    private class P_MouseMoveListener
    implements MouseMoveListener {
        private P_MouseMoveListener() {
        }

        public void mouseMove(MouseEvent event) {
            block10: {
                if (TableMouseMoveSelectionSupport.this.m_dndSupport != null && TableMouseMoveSelectionSupport.this.m_dndSupport.isDraggingEnabled()) {
                    TableMouseMoveSelectionSupport.this.m_itemToSelect = TableMouseMoveSelectionSupport.this.getTable().getItem(new Point(event.x, event.y));
                    TableMouseMoveSelectionSupport.this.m_existingSelection = TableMouseMoveSelectionSupport.this.getTable().getSelection();
                }
                if (!TableMouseMoveSelectionSupport.this.m_mouseDown || TableMouseMoveSelectionSupport.this.m_selectionStartIndex == -1) {
                    return;
                }
                TableMouseMoveSelectionSupport.this.m_itemToSelect = TableMouseMoveSelectionSupport.this.getTable().getItem(new Point(event.x, event.y));
                if (TableMouseMoveSelectionSupport.this.m_itemToSelect == null) break block10;
                int currentIndex = TableMouseMoveSelectionSupport.this.getTable().indexOf(TableMouseMoveSelectionSupport.this.m_itemToSelect);
                if ((event.stateMask & SWT.MOD1) == 0) {
                    if (TableMouseMoveSelectionSupport.this.m_selectionStartIndex <= currentIndex) {
                        TableMouseMoveSelectionSupport.this.getTable().setSelection(TableMouseMoveSelectionSupport.this.m_selectionStartIndex, currentIndex);
                    } else {
                        TableMouseMoveSelectionSupport.this.getTable().setSelection(currentIndex, TableMouseMoveSelectionSupport.this.m_selectionStartIndex);
                    }
                } else if (TableMouseMoveSelectionSupport.this.m_selectionStartIndex <= currentIndex) {
                    int row = TableMouseMoveSelectionSupport.this.m_selectionStartIndex;
                    while (row <= currentIndex) {
                        TableMouseMoveSelectionSupport.this.getTable().select(row);
                        ++row;
                    }
                } else {
                    int row = currentIndex;
                    while (row < TableMouseMoveSelectionSupport.this.m_selectionStartIndex) {
                        TableMouseMoveSelectionSupport.this.getTable().select(row);
                        ++row;
                    }
                }
            }
        }
    }

    private class P_MouseTrackListener
    extends MouseTrackAdapter {
        private P_MouseTrackListener() {
        }

        public void mouseExit(MouseEvent e) {
            TableMouseMoveSelectionSupport.this.stopSelecting();
        }
    }

    private class P_SelectionListener
    extends SelectionAdapter {
        private P_SelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (TableMouseMoveSelectionSupport.this.m_dndSupport != null && TableMouseMoveSelectionSupport.this.m_dndSupport.isDraggingEnabled()) {
                TableMouseMoveSelectionSupport.this.m_existingSelection = TableMouseMoveSelectionSupport.this.getTable().getSelection();
            }
        }
    }
}

