/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutDndSupport;
import org.eclipse.scout.rt.ui.swt.util.SwtTransferObject;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractSwtScoutDndSupport
implements ISwtScoutDndSupport {
    private final Control m_control;
    private final IPropertyObserver m_scoutObject;
    private final IDNDSupport m_scoutDndSupportable;
    private final ISwtEnvironment m_environment;
    private DropTargetListener m_dropTargetListener;
    private DragSourceListener m_dragSourceListener;
    private PropertyChangeListener m_scoutPropertyListener;
    private Transfer[] m_dragTransferTypes;
    private Transfer[] m_dropTransferTypes;

    public AbstractSwtScoutDndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control, ISwtEnvironment environment) {
        this.m_scoutObject = scoutObject;
        this.m_scoutDndSupportable = scoutDndSupportable;
        this.m_control = control;
        this.m_environment = environment;
        this.attachScout();
        this.m_control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractSwtScoutDndSupport.this.detachScout();
            }
        });
    }

    protected void attachScout() {
        this.m_scoutPropertyListener = new P_ScoutObjectPropertyListener();
        this.m_scoutObject.addPropertyChangeListener(this.m_scoutPropertyListener);
        this.updateDragSupportFromScout();
        this.updateDropSupportFromScout();
    }

    protected void detachScout() {
        DropTarget dropTarget;
        Transfer t;
        int n;
        int n2;
        Transfer[] transferArray;
        ArrayList<Transfer> types;
        DragSource dragSource;
        this.m_scoutObject.removePropertyChangeListener(this.m_scoutPropertyListener);
        if (this.m_dragTransferTypes != null && (dragSource = (DragSource)this.m_control.getData("DragSource")) != null && !dragSource.isDisposed()) {
            dragSource.removeDragListener(this.m_dragSourceListener);
            types = new ArrayList<Transfer>(Arrays.asList(dragSource.getTransfer()));
            transferArray = this.m_dragTransferTypes;
            n2 = this.m_dragTransferTypes.length;
            n = 0;
            while (n < n2) {
                t = transferArray[n];
                types.remove(t);
                ++n;
            }
            if (types.size() > 0) {
                dragSource.setTransfer(types.toArray(new Transfer[types.size()]));
            } else {
                dragSource.dispose();
                this.m_control.setData("DragSource", null);
            }
        }
        if (this.m_dropTransferTypes != null && (dropTarget = (DropTarget)this.m_control.getData("DropTarget")) != null && !dropTarget.isDisposed()) {
            dropTarget.removeDropListener(this.m_dropTargetListener);
            types = new ArrayList<Transfer>(Arrays.asList(dropTarget.getTransfer()));
            transferArray = this.m_dropTransferTypes;
            n2 = this.m_dropTransferTypes.length;
            n = 0;
            while (n < n2) {
                t = transferArray[n];
                types.remove(t);
                ++n;
            }
            if (types.size() > 0) {
                dropTarget.setTransfer(types.toArray(new Transfer[types.size()]));
            } else {
                dropTarget.dispose();
                this.m_control.setData("DropTarget", null);
            }
        }
    }

    protected abstract void handleSwtDropAction(DropTargetEvent var1, TransferObject var2);

    protected abstract TransferObject handleSwtDragRequest();

    protected boolean acceptDrag() {
        return true;
    }

    @Override
    public boolean isDraggingEnabled() {
        return this.m_control.getData("DragSource") != null;
    }

    protected void updateDragSupportFromScout() {
        if (this.m_scoutObject == null || this.m_control == null || this.m_control.isDisposed()) {
            return;
        }
        int scoutType = this.m_scoutDndSupportable.getDragType();
        Transfer[] swtTransferTypes = SwtUtility.convertScoutTransferTypes(scoutType);
        DragSource dragSource = (DragSource)this.m_control.getData("DragSource");
        if (dragSource == null && swtTransferTypes.length > 0) {
            dragSource = new DragSource(this.m_control, 1);
        }
        if (dragSource != null) {
            Transfer t;
            int n;
            int n2;
            Transfer[] transferArray;
            ArrayList<Transfer> types = new ArrayList<Transfer>(Arrays.asList(dragSource.getTransfer()));
            if (this.m_dragTransferTypes != null) {
                transferArray = this.m_dragTransferTypes;
                n2 = this.m_dragTransferTypes.length;
                n = 0;
                while (n < n2) {
                    t = transferArray[n];
                    types.remove(t);
                    ++n;
                }
                this.m_dragTransferTypes = null;
            }
            transferArray = this.m_dragTransferTypes = swtTransferTypes;
            n2 = this.m_dragTransferTypes.length;
            n = 0;
            while (n < n2) {
                t = transferArray[n];
                types.add(t);
                ++n;
            }
            if (types.size() > 0) {
                dragSource.setTransfer(types.toArray(new Transfer[types.size()]));
                if (this.m_dragSourceListener == null) {
                    this.m_dragSourceListener = new P_SwtDragSourceListener();
                    dragSource.addDragListener(this.m_dragSourceListener);
                }
            } else {
                if (this.m_dragSourceListener != null) {
                    dragSource.removeDragListener(this.m_dragSourceListener);
                    this.m_dragSourceListener = null;
                }
                dragSource.dispose();
            }
        }
    }

    protected void updateDropSupportFromScout() {
        if (this.m_scoutObject == null || this.m_control == null || this.m_control.isDisposed()) {
            return;
        }
        int scoutType = this.m_scoutDndSupportable.getDropType();
        Transfer[] swtTransferTypes = SwtUtility.convertScoutTransferTypes(scoutType);
        DropTarget dropTarget = (DropTarget)this.m_control.getData("DropTarget");
        if (dropTarget == null && swtTransferTypes.length > 0) {
            dropTarget = new DropTarget(this.m_control, 3);
        }
        if (dropTarget != null) {
            Transfer t;
            int n;
            int n2;
            Transfer[] transferArray;
            ArrayList<Transfer> types = new ArrayList<Transfer>(Arrays.asList(dropTarget.getTransfer()));
            if (this.m_dropTransferTypes != null) {
                transferArray = this.m_dropTransferTypes;
                n2 = this.m_dropTransferTypes.length;
                n = 0;
                while (n < n2) {
                    t = transferArray[n];
                    types.remove(t);
                    ++n;
                }
                this.m_dropTransferTypes = null;
            }
            transferArray = this.m_dropTransferTypes = swtTransferTypes;
            n2 = this.m_dropTransferTypes.length;
            n = 0;
            while (n < n2) {
                t = transferArray[n];
                types.add(t);
                ++n;
            }
            if (types.size() > 0) {
                dropTarget.setTransfer(types.toArray(new Transfer[types.size()]));
                if (this.m_dropTargetListener == null) {
                    this.m_dropTargetListener = new P_SwtDropTargetListener();
                    dropTarget.addDropListener(this.m_dropTargetListener);
                }
            } else {
                if (this.m_dropTargetListener != null) {
                    dropTarget.removeDropListener(this.m_dropTargetListener);
                    this.m_dropTargetListener = null;
                }
                dropTarget.dispose();
            }
        }
    }

    protected void handleScoutProperty(String name, Object newValue) {
        if ("dragType".equals(name)) {
            this.updateDragSupportFromScout();
        } else if ("dropType".equals(name)) {
            this.updateDropSupportFromScout();
        }
    }

    private class P_ScoutObjectPropertyListener
    implements PropertyChangeListener {
        private P_ScoutObjectPropertyListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    AbstractSwtScoutDndSupport.this.handleScoutProperty(evt.getPropertyName(), evt.getNewValue());
                }
            };
            AbstractSwtScoutDndSupport.this.m_environment.invokeSwtLater(job);
        }
    }

    private class P_SwtDragSourceListener
    extends DragSourceAdapter {
        private P_SwtDragSourceListener() {
        }

        public void dragStart(DragSourceEvent event) {
            if (!AbstractSwtScoutDndSupport.this.acceptDrag()) {
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            TransferObject scoutTransferObject = AbstractSwtScoutDndSupport.this.handleSwtDragRequest();
            if (scoutTransferObject == null) {
                return;
            }
            SwtTransferObject[] swtTransferables = SwtUtility.createSwtTransferables(scoutTransferObject);
            if (swtTransferables.length == 0) {
                return;
            }
            Object data = swtTransferables[0].getData();
            if (data == null) {
                return;
            }
            event.data = data;
        }
    }

    private class P_SwtDropTargetListener
    extends DropTargetAdapter {
        private P_SwtDropTargetListener() {
        }

        public void dropAccept(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            TransferObject scoutTransferable = SwtUtility.createScoutTransferable(event);
            if (scoutTransferable != null) {
                AbstractSwtScoutDndSupport.this.handleSwtDropAction(event, scoutTransferable);
            }
        }
    }
}

