/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.groupbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.form.fields.groupbox.ISwtScoutGroupBoxButtonbar;
import org.eclipse.scout.rt.ui.swt.form.fields.groupbox.layout.ButtonBarLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutGroupBoxButtonbar
implements ISwtScoutGroupBoxButtonbar {
    private Composite m_swtContainer;
    private Composite m_leftPart;
    private Composite m_rightPart;
    private ISwtEnvironment m_environment;
    private IGroupBox m_scoutGroupBox;
    private PropertyChangeListener m_scoutButtonVisibleListener;

    public void createField(Composite parent, IGroupBox scoutGroupBox, ISwtEnvironment environment) {
        this.m_scoutGroupBox = scoutGroupBox;
        this.m_environment = environment;
        this.m_swtContainer = this.getEnvironment().getFormToolkit().createComposite(parent);
        this.m_leftPart = this.getEnvironment().getFormToolkit().createComposite(this.m_swtContainer);
        this.m_rightPart = this.getEnvironment().getFormToolkit().createComposite(this.m_swtContainer);
        GridLayout buttonBarLayout = new GridLayout(3, false);
        buttonBarLayout.horizontalSpacing = 0;
        buttonBarLayout.verticalSpacing = 0;
        buttonBarLayout.marginTop = 6;
        buttonBarLayout.marginHeight = 0;
        buttonBarLayout.marginWidth = 0;
        this.m_swtContainer.setLayout((Layout)buttonBarLayout);
        this.m_leftPart.setLayoutData((Object)new GridData(1, 0x1000000, true, true));
        this.m_rightPart.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        this.m_leftPart.setLayout((Layout)new ButtonBarLayout(16384));
        this.m_rightPart.setLayout((Layout)new ButtonBarLayout(131072));
        IFormField[] iFormFieldArray = this.getScoutGroupBox().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IButton b;
            IFormField f = iFormFieldArray[n2];
            if (f instanceof IButton && (b = (IButton)f).isProcessButton()) {
                if (b.getGridData().horizontalAlignment <= 0) {
                    this.getEnvironment().createFormField(this.m_leftPart, (IFormField)b);
                } else {
                    this.getEnvironment().createFormField(this.m_rightPart, (IFormField)b);
                }
            }
            ++n2;
        }
    }

    protected void attachScout() {
        this.detachScout();
        this.m_scoutButtonVisibleListener = new P_ScoutButtonVisiblePropertyListener();
        IFormField[] iFormFieldArray = this.getScoutGroupBox().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IButton b;
            IFormField f = iFormFieldArray[n2];
            if (f instanceof IButton && (b = (IButton)f).isProcessButton()) {
                b.addPropertyChangeListener("visible", this.m_scoutButtonVisibleListener);
            }
            ++n2;
        }
    }

    protected void detachScout() {
        if (this.m_scoutButtonVisibleListener != null) {
            IFormField[] iFormFieldArray = this.getScoutGroupBox().getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IButton b;
                IFormField f = iFormFieldArray[n2];
                if (f instanceof IButton && (b = (IButton)f).isProcessButton()) {
                    b.removePropertyChangeListener("visible", this.m_scoutButtonVisibleListener);
                }
                ++n2;
            }
            this.m_scoutButtonVisibleListener = null;
        }
    }

    public void updateButtonbarVisibility() {
        Control c;
        boolean excludeLeft = true;
        boolean excludeRight = true;
        Control[] controlArray = this.m_leftPart.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = controlArray[n2];
            if (c.getVisible()) {
                excludeLeft = false;
                break;
            }
            ++n2;
        }
        ((GridData)this.m_leftPart.getLayoutData()).exclude = excludeLeft;
        controlArray = this.m_rightPart.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            c = controlArray[n2];
            if (c.getVisible()) {
                excludeRight = false;
                break;
            }
            ++n2;
        }
        ((GridData)this.m_rightPart.getLayoutData()).exclude = excludeRight;
        if (!excludeLeft || !excludeRight) {
            this.m_swtContainer.layout(true, true);
        }
        if (!excludeLeft) {
            this.m_leftPart.layout(true, true);
            this.m_leftPart.pack();
        }
        if (!excludeRight) {
            this.m_leftPart.layout(true, true);
            this.m_rightPart.pack();
        }
        ((GridData)this.getSwtContainer().getLayoutData()).exclude = excludeLeft && excludeRight;
    }

    public IGroupBox getScoutGroupBox() {
        return this.m_scoutGroupBox;
    }

    public Composite getSwtContainer() {
        return this.m_swtContainer;
    }

    public Composite getLeftPart() {
        return this.m_leftPart;
    }

    public Composite getRightPart() {
        return this.m_rightPart;
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    private class P_ScoutButtonVisiblePropertyListener
    implements PropertyChangeListener {
        private P_ScoutButtonVisiblePropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    if (SwtScoutGroupBoxButtonbar.this.getSwtContainer() != null && !SwtScoutGroupBoxButtonbar.this.getSwtContainer().isDisposed()) {
                        SwtScoutGroupBoxButtonbar.this.updateButtonbarVisibility();
                    }
                }
            };
            SwtScoutGroupBoxButtonbar.this.getEnvironment().invokeSwtLater(job);
        }
    }
}

