/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.io.Reader;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.TableFieldNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.PageWithTableNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.ColumnTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.TableNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class TableColumnWidthsPasteAction
extends AbstractScoutHandler {
    private static final String COLUMN_WIDTH_METHOD_NAME = "getConfiguredWidth";

    public TableColumnWidthsPasteAction() {
        super(Texts.get((String)"Action_PasteColumnWidths"), ScoutSdkUi.getImageDescriptor("tableColumn.png"), "CTRL+V", false, IScoutHandler.Category.IMPORT);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) {
        String content = this.getStringFromClipboard();
        if (content != null && selection != null && selection.length == 1) {
            IType tableType;
            if (!this.fastDetection(content)) {
                this.showInfoMessageBox(shell, Texts.get((String)"Action_PasteColumnWidths_InvalidClipboard"));
                return null;
            }
            HashMap<String, Integer> map = this.parseContent(content, shell);
            if (map != null && (tableType = this.determineTableType(selection[0], shell, map.keySet())) != null) {
                this.changeColumnWidths(tableType, map);
            }
        }
        return null;
    }

    private boolean fastDetection(String content) {
        try {
            String identifier = (String)TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.menus.CopyWidthsOfColumnsMenu").getField("COLUMN_COPY_CLIPBOARD_IDENTIFIER").getConstant();
            if (identifier != null && identifier.startsWith("\"") && identifier.endsWith("\"")) {
                identifier = identifier.substring(1, identifier.length() - 1);
            }
            return content.startsWith(identifier);
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("Unable to get the identification constant from the scout class", e);
            return true;
        }
    }

    private String getStringFromClipboard() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Reader reader = DataFlavor.stringFlavor.getReaderForText(clipboard.getContents(null));
            return IOUtility.getContent((Reader)reader);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, Integer> parseContent(String content, Shell s) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            content = content.replaceAll("\r", "");
            String[] lines = content.split("\n");
            int i = 1;
            while (true) {
                if (i >= lines.length) {
                    return map;
                }
                String line = lines[i];
                if (StringUtility.hasText((String)line)) {
                    String[] parts = line.split("\t");
                    Integer columnWidth = NumberUtility.nvl((Integer)new Integer(parts[1]), (Number)0);
                    if (columnWidth < 0) {
                        this.showInfoMessageBox(s, Texts.get((String)"ColumnWidthPasteInvalidWidth", (String[])new String[]{columnWidth.toString()}));
                        return null;
                    }
                    map.put(parts[0], columnWidth);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void showInfoMessageBox(Shell s, String message) {
        MessageBox msgBox = new MessageBox(s, 34);
        msgBox.setMessage(message);
        msgBox.open();
    }

    private void changeColumnWidths(IType tableType, HashMap<String, Integer> map) {
        IType[] iTypeArray = ScoutTypeUtility.getColumns((IType)tableType);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType innerType = iTypeArray[n2];
            String className = innerType.getFullyQualifiedName();
            Integer columnWidth = map.get(className);
            if (columnWidth != null) {
                ConfigPropertyMethodUpdateOperation op = new ConfigPropertyMethodUpdateOperation(innerType, COLUMN_WIDTH_METHOD_NAME, "  return " + columnWidth.toString() + ";", true);
                new OperationJob(new IOperation[]{op}).schedule();
            }
            ++n2;
        }
    }

    private IType determineTableType(IPage page, Shell s, Set<String> classNames) {
        IType[] tables;
        IType tableType = null;
        if (page instanceof ColumnTablePage) {
            tableType = ((ColumnTablePage)page).getColumnDeclaringType();
        } else if (page instanceof PageWithTableNodePage) {
            tables = ScoutTypeUtility.getTables((IType)((PageWithTableNodePage)page).getType());
            if (tables.length > 0) {
                tableType = tables[0];
            } else {
                ScoutSdkUi.logInfo(Texts.get((String)"ColumnWidthPasteNoTableInPage"));
                this.showInfoMessageBox(s, Texts.get((String)"ColumnWidthPasteNoTableInPage"));
            }
        } else if (page instanceof TableFieldNodePage) {
            tables = ScoutTypeUtility.getTables((IType)((TableFieldNodePage)page).getType());
            if (tables.length > 0) {
                tableType = tables[0];
            } else {
                ScoutSdkUi.logInfo(Texts.get((String)"ColumnWidthPasteNoTableInField"));
                this.showInfoMessageBox(s, Texts.get((String)"ColumnWidthPasteNoTableInField"));
            }
        } else if (page instanceof TableNodePage) {
            tableType = ((TableNodePage)page).getType();
        } else {
            ScoutSdkUi.logInfo(Texts.get((String)"ColumnWidthPasteUnsupportedSelection"));
            this.showInfoMessageBox(s, Texts.get((String)"ColumnWidthPasteUnsupportedSelection"));
        }
        if (tableType != null) {
            String tableTypeClassName = tableType.getFullyQualifiedName();
            for (String clazz : classNames) {
                if (clazz.startsWith(tableTypeClassName)) continue;
                ScoutSdkUi.logInfo(Texts.get((String)"ColumnWidthPasteDifferentTable", (String[])new String[]{tableTypeClassName, clazz}));
                this.showInfoMessageBox(s, Texts.get((String)"ColumnWidthPasteDifferentTable", (String[])new String[]{tableTypeClassName, clazz}));
                tableType = null;
                break;
            }
        }
        return tableType;
    }
}

