/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class ServiceRenameAction
extends AbstractRenameAction {
    private IType m_serviceInterface;
    private IType m_serviceImplementation;

    @Override
    protected IStatus validate(String newName) {
        String packName;
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        if (this.m_serviceImplementation != null && TypeUtility.existsType((String)(String.valueOf(packName = this.m_serviceImplementation.getPackageFragment().getElementName()) + "." + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
        }
        if (this.m_serviceInterface != null && TypeUtility.existsType((String)(String.valueOf(packName = this.m_serviceInterface.getPackageFragment().getElementName()) + ".I" + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
        }
        return inheritedStatus;
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.m_serviceImplementation, newName);
        if (TypeUtility.exists((IJavaElement)this.m_serviceInterface) && !this.m_serviceInterface.isBinary()) {
            transaction.add(this.m_serviceInterface, "I" + newName);
        }
    }

    public void setServiceInterface(IType serviceInterface) {
        this.m_serviceInterface = serviceInterface;
    }

    public void setServiceImplementation(IType serviceImplementation) {
        this.m_serviceImplementation = serviceImplementation;
    }
}

