/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CheckableTreeSelectionDialog
extends TitleAreaDialog {
    public static final String PROP_CHECKED_NODES = "checkedNodes";
    public static final String PROP_SELECTED_NODE = "selectedNodes";
    private BasicPropertySupport m_propertySupport;
    private ITreeNode m_rootNode;
    private CheckableTree m_tree;
    private OptimisticLock m_uiLock = new OptimisticLock();
    private boolean m_complete;
    private String m_message;
    private String m_title;

    public CheckableTreeSelectionDialog(Shell parentShell, ITreeNode rootNode) {
        this(parentShell, rootNode, null, null);
    }

    public CheckableTreeSelectionDialog(Shell parentShell, ITreeNode rootNode, String dialogTitle, String message) {
        super(parentShell);
        this.m_rootNode = rootNode;
        this.m_title = dialogTitle;
        this.m_message = message;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_propertySupport = new BasicPropertySupport((Object)this);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.setMessage(this.m_message);
        this.setTitle(this.m_title);
        this.m_tree.setChecked(this.getCheckedNodes());
        return c;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonbar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.isComplete());
        return buttonbar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootPane = new Composite(parent, 0);
        this.m_tree = new CheckableTree(rootPane, this.getRootNode());
        this.m_tree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                try {
                    if (CheckableTreeSelectionDialog.this.m_uiLock.acquire()) {
                        ArrayList<ITreeNode> checkedNodes = new ArrayList<ITreeNode>();
                        ITreeNode[] iTreeNodeArray = CheckableTreeSelectionDialog.this.m_tree.getCheckedNodes();
                        int n = iTreeNodeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITreeNode n3 = iTreeNodeArray[n2];
                            checkedNodes.add(n3);
                            ++n2;
                        }
                        CheckableTreeSelectionDialog.this.setCheckedNodes(checkedNodes.toArray(new ITreeNode[checkedNodes.size()]));
                    }
                }
                finally {
                    CheckableTreeSelectionDialog.this.m_uiLock.release();
                }
            }
        });
        this.m_tree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    if (CheckableTreeSelectionDialog.this.m_uiLock.acquire()) {
                        ITreeNode selectedNode = null;
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        if (!selection.isEmpty()) {
                            selectedNode = (ITreeNode)selection.getFirstElement();
                        }
                        if (selectedNode != null) {
                            CheckableTreeSelectionDialog.this.setSelectedNode(selectedNode);
                        }
                    }
                }
                finally {
                    CheckableTreeSelectionDialog.this.m_uiLock.release();
                }
            }
        });
        if (parent.getLayout() instanceof GridLayout) {
            rootPane.setLayoutData((Object)new GridData(1808));
        }
        rootPane.setLayout((Layout)new GridLayout(1, true));
        this.m_tree.setLayoutData(new GridData(1808));
        return rootPane;
    }

    public void setComplete(boolean complete) {
        this.m_complete = complete;
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getButton(0).setEnabled(complete);
        }
    }

    public boolean isComplete() {
        return this.m_complete;
    }

    public ITreeNode getRootNode() {
        return this.m_rootNode;
    }

    public ITreeNode[] getCheckedNodes() {
        ITreeNode[] checkedNodes = (ITreeNode[])this.m_propertySupport.getProperty(PROP_CHECKED_NODES);
        if (checkedNodes == null) {
            checkedNodes = new ITreeNode[]{};
        }
        return checkedNodes;
    }

    public void setCheckedNodes(ITreeNode[] checkedNodes) {
        this.m_propertySupport.setProperty(PROP_CHECKED_NODES, (Object)checkedNodes);
        if (this.m_tree != null && !this.m_tree.isDisposed()) {
            try {
                this.m_uiLock.acquire();
                this.m_tree.setChecked(checkedNodes);
            }
            finally {
                this.m_uiLock.release();
            }
        }
    }

    public ITreeNode getSelectedNode() {
        return (ITreeNode)this.m_propertySupport.getProperty(PROP_SELECTED_NODE);
    }

    public void setSelectedNode(ITreeNode node) {
        this.m_propertySupport.setProperty(PROP_SELECTED_NODE, (Object)node);
        if (this.m_tree != null && !this.m_tree.isDisposed()) {
            try {
                this.m_uiLock.acquire();
                this.m_tree.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node), true);
            }
            finally {
                this.m_uiLock.release();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }
}

