/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.javaelement;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.MoreElementsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.ISearchRangeConsumer;

public abstract class AbstractJavaElementContentProvider
extends ContentProposalProvider {
    private final ILabelProvider m_labelProvider = new JavaElementLabelProvider();
    private Object[][] m_allProposals = null;

    protected AbstractJavaElementContentProvider() {
    }

    public ILabelProvider getLabelProvider() {
        return this.m_labelProvider;
    }

    protected abstract Object[][] computeProposals();

    private Object[][] getAllProposals() {
        if (this.m_allProposals == null) {
            this.m_allProposals = this.computeProposals();
        }
        return this.m_allProposals;
    }

    @Override
    public Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
        if (!StringUtility.hasText((String)searchPattern)) {
            searchPattern = "*";
        }
        ContentProposalProvider.NormalizedPattern pattern = AbstractJavaElementContentProvider.createNormalizedSearchPattern(searchPattern);
        ArrayList<Object> result = new ArrayList<Object>();
        ISearchRangeConsumer searchRangeSupport = null;
        searchRangeSupport = this.getLabelProvider() instanceof ISearchRangeConsumer ? (ISearchRangeConsumer)this.getLabelProvider() : new P_EmptySearchRangeSupport();
        Object[][] objectArray = this.getAllProposals();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] group = objectArray[n2];
            Collection<Object> groupResult = this.getProposals(pattern, group, searchRangeSupport, monitor);
            if (result.size() > 0 && groupResult.size() > 0) {
                result.add(MoreElementsProposal.INSTANCE);
            }
            result.addAll(groupResult);
            ++n2;
        }
        return result.toArray(new Object[result.size()]);
    }

    private Collection<Object> getProposals(ContentProposalProvider.NormalizedPattern pattern, Object[] proposals, ISearchRangeConsumer searchRangeSupport, IProgressMonitor monitor) {
        if (proposals == null) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            Object proposal = objectArray[n2];
            int[] matchingRegions = this.getMatchingRegions(proposal, this.getLabelProvider().getText(proposal), pattern);
            if (matchingRegions != null) {
                result.add(proposal);
                searchRangeSupport.addMatchRegions(proposal, matchingRegions);
            }
            ++n2;
        }
        return result;
    }

    private class P_EmptySearchRangeSupport
    implements ISearchRangeConsumer {
        private P_EmptySearchRangeSupport() {
        }

        @Override
        public int[] getMatchRanges(Object element) {
            return null;
        }

        @Override
        public void startRecordMatchRegions() {
        }

        @Override
        public void addMatchRegions(Object element, int[] matchRegions) {
        }

        @Override
        public void endRecordMatchRegions() {
        }
    }
}

