/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.form.formdata.ScoutProjectUpdateFormDataOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformScoutProjectOperation;
import org.eclipse.scout.sdk.ui.action.FormDataUpdateAction;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ImportPluginAction;
import org.eclipse.scout.sdk.ui.action.OrganizeAllImportsAction;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutBundleNewAction;
import org.eclipse.scout.sdk.ui.action.export.ExportScoutProjectAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.UiSwingNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.UiSwtNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.IProjectNodePage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.IScoutWorkspaceListener;
import org.eclipse.scout.sdk.workspace.ScoutWorkspaceEvent;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class ProjectNodePage
extends AbstractPage
implements IProjectNodePage {
    private IScoutProject m_scoutProject;
    final IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
    private IScoutWorkspaceListener m_workspaceListener = new IScoutWorkspaceListener(){

        public void worspaceChanged(ScoutWorkspaceEvent event) {
            if (event.getType() == 4 && CompareUtility.equals((Object)event.getScoutElement(), (Object)ProjectNodePage.this.m_scoutProject)) {
                ProjectNodePage.this.markStructureDirty();
            }
        }
    };

    public ProjectNodePage(IPage parent, IScoutProject p) {
        this.setParent(parent);
        this.m_scoutProject = p;
        this.setName(p.getProjectName());
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("projectGroup.png"));
        ScoutSdkCore.getScoutWorkspace().addWorkspaceListener(this.m_workspaceListener);
    }

    @Override
    public void unloadPage() {
        ScoutSdkCore.getScoutWorkspace().removeWorkspaceListener(this.m_workspaceListener);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ProjectNodePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public IScoutProject getScoutResource() {
        return this.m_scoutProject;
    }

    @Override
    public void loadChildrenImpl() {
        try {
            if (this.getScoutResource().getUiSwingBundle() != null) {
                new UiSwingNodePage(this, this.getScoutResource().getUiSwingBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for UI swing bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        try {
            if (this.getScoutResource().getUiSwtBundle() != null) {
                new UiSwtNodePage(this, this.getScoutResource().getUiSwtBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for UI SWT bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        try {
            if (this.getScoutResource().getClientBundle() != null) {
                new ClientNodePage(this, this.getScoutResource().getClientBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for Client Bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        try {
            if (this.getScoutResource().getSharedBundle() != null) {
                new SharedNodePage(this, this.getScoutResource().getSharedBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for Shared Bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        try {
            if (this.getScoutResource().getServerBundle() != null) {
                new ServerNodePage(this, this.getScoutResource().getServerBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for Server Bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        IScoutProject[] subProjects = this.getScoutResource().getSubProjects();
        Arrays.sort(subProjects, 0, subProjects.length, new Comparator<IScoutProject>(){

            @Override
            public int compare(IScoutProject o1, IScoutProject o2) {
                return o1.getProjectName().compareTo(o2.getProjectName());
            }
        });
        IScoutProject[] iScoutProjectArray = subProjects;
        int n = subProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutProject subProject = iScoutProjectArray[n2];
            try {
                new ProjectNodePage(this, subProject);
            }
            catch (Exception e) {
                ScoutSdkUi.logWarning("Error during creating node page for Project '" + subProject.getProjectName() + "'.", e);
            }
            ++n2;
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{ImportPluginAction.class, OrganizeAllImportsAction.class, WellformAction.class, FormDataUpdateAction.class, FormDataSqlBindingValidateAction.class, ExportScoutProjectAction.class, ScoutBundleNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof OrganizeAllImportsAction) {
            ((OrganizeAllImportsAction)menu).setScoutProject(this.getScoutResource());
        } else if (menu instanceof WellformAction) {
            ((WellformAction)menu).setOperation((IOperation)new WellformScoutProjectOperation(this.getScoutResource()));
        } else if (menu instanceof FormDataUpdateAction) {
            ((FormDataUpdateAction)menu).setOperation((IOperation)new ScoutProjectUpdateFormDataOperation(this.getScoutResource()));
        } else if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setTyperesolver(new ITypeResolver(){

                @Override
                public IType[] getTypes() {
                    return ProjectNodePage.this.resolveServices();
                }
            });
        } else if (menu instanceof ExportScoutProjectAction) {
            ((ExportScoutProjectAction)menu).setScoutProject(this.getScoutResource());
        } else if (menu instanceof ScoutBundleNewAction) {
            ((ScoutBundleNewAction)menu).setScoutProject(this.getScoutResource());
        }
    }

    protected IType[] resolveServices() {
        IPrimaryTypeTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iService);
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassFilter(), ScoutTypeFilters.getTypesInScoutProject((IScoutProject)this.getScoutResource(), (boolean)true)});
        IType[] services = serviceHierarchy.getAllSubtypes(this.iService, filter);
        return services;
    }
}

