/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom;

import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.CustomServiceNewPackageAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom.CustomServicePackageNodePage;
import org.eclipse.scout.sdk.ui.type.PackageContentChangedListener;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class CustomServiceTablePage
extends AbstractPage {
    final IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
    private PackageContentChangedListener m_changedListener;
    private IPackageFragment m_servicePackage;

    public CustomServiceTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"CustomServices"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("services.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_changedListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.m_changedListener);
            this.m_changedListener = null;
        }
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CustomServiceTablePage";
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    protected void loadChildrenImpl() {
        this.m_servicePackage = this.getScoutResource().getPackageFragment(this.getScoutResource().getPackageName(".services.custom"));
        if (this.m_changedListener == null) {
            this.m_changedListener = new PackageContentChangedListener(this, this.m_servicePackage);
            JavaCore.addElementChangedListener((IElementChangedListener)this.m_changedListener);
        }
        IPackageFragment[] iPackageFragmentArray = TypeUtility.getSubPackages((IPackageFragment)this.m_servicePackage);
        int n = iPackageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment pFrag = iPackageFragmentArray[n2];
            String appendix = pFrag.getElementName().replaceFirst(String.valueOf(this.m_servicePackage.getElementName()) + ".", "");
            CustomServicePackageNodePage node = new CustomServicePackageNodePage(this, pFrag);
            node.setName(appendix);
            ++n2;
        }
    }

    protected IType[] resolveServices() {
        IPrimaryTypeTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iService);
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassFilter(), TypeFilters.getSubtypeFilter((IType)this.iService, (ITypeHierarchy)serviceHierarchy)});
        IType[] services = TypeUtility.getTypesInPackage((IPackageFragment)this.m_servicePackage, (ITypeFilter)filter, null, (boolean)true);
        return services;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{FormDataSqlBindingValidateAction.class, CustomServiceNewPackageAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setTyperesolver(new ITypeResolver(){

                @Override
                public IType[] getTypes() {
                    return CustomServiceTablePage.this.resolveServices();
                }
            });
        } else if (menu instanceof CustomServiceNewPackageAction) {
            ((CustomServiceNewPackageAction)menu).setScoutBundle(this.getScoutResource());
        }
    }
}

