/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.osgi.framework.Version;

public class ProjectVersionPresenter
extends AbstractPresenter {
    private Text m_versionField;
    private ImageHyperlink m_applyVersionLink;
    private final HashMap<IProject, PluginModelHelper> m_bundles;

    public ProjectVersionPresenter(PropertyViewFormToolkit toolkit, Composite parent, IScoutProject scoutProject) {
        super(toolkit, parent);
        IScoutBundle[] scoutBundles = scoutProject.getAllScoutBundles();
        this.m_bundles = new HashMap(scoutBundles.length);
        IScoutBundle[] iScoutBundleArray = scoutBundles;
        int n = scoutBundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle sb = iScoutBundleArray[n2];
            this.m_bundles.put(sb.getProject(), new PluginModelHelper(sb.getProject()));
            ++n2;
        }
        this.createContent(this.getContainer());
    }

    private void createContent(Composite container) {
        this.m_versionField = this.getToolkit().createText(container, this.getCommonPluginVerionString(), 2048);
        this.m_applyVersionLink = this.getToolkit().createImageHyperlink(container, 8);
        this.m_applyVersionLink.setImage(ScoutSdkUi.getImage("rename.gif"));
        this.m_applyVersionLink.setToolTipText(Texts.get((String)"ApplyVersion"));
        this.m_versionField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    ProjectVersionPresenter.this.m_versionField.setText(ProjectVersionPresenter.this.getCommonPluginVerionString());
                } else if (e.keyCode == 13) {
                    ProjectVersionPresenter.this.updatePluginVersions();
                }
            }
        });
        this.m_applyVersionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ProjectVersionPresenter.this.updatePluginVersions();
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.m_versionField.setLayoutData((Object)new GridData(1808));
        this.m_applyVersionLink.setLayoutData((Object)new GridData(1040));
    }

    private Version parseVersion() {
        String txt = this.m_versionField.getText();
        try {
            return Version.parseVersion((String)txt);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private void updatePluginVersions() {
        Version newVersion = this.parseVersion();
        if (newVersion != null) {
            MessageBox box;
            String newVersionStr = newVersion.toString();
            LinkedList<String> errPlugins = new LinkedList<String>();
            for (IProject p : this.m_bundles.keySet()) {
                PluginModelHelper mf = this.m_bundles.get(p);
                if (newVersionStr.equals(mf.Manifest.getVersionAsString())) continue;
                try {
                    mf.Manifest.setVersion(newVersionStr);
                    mf.save();
                }
                catch (Exception e) {
                    errPlugins.add(p.getName());
                    ScoutSdkUi.logError("Unable to set the new version for plugin " + p.getName(), e);
                }
            }
            if (errPlugins.size() < 1) {
                box = new MessageBox(Display.getCurrent().getActiveShell(), 34);
                box.setMessage(Texts.get((String)"VersionApplySuccess"));
                box.open();
            } else {
                box = new MessageBox(Display.getCurrent().getActiveShell(), 33);
                StringBuilder sb = new StringBuilder(Texts.get((String)"VersionApplyErr"));
                sb.append("\n");
                for (String pluginName : errPlugins) {
                    sb.append(pluginName);
                    sb.append("\n");
                }
                box.setMessage(sb.toString());
                box.open();
            }
        } else {
            MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 34);
            box.setMessage(Texts.get((String)"VersionApplyWrongFormat"));
            box.open();
        }
    }

    private String getCommonPluginVerionString() {
        String v = null;
        for (PluginModelHelper b : this.m_bundles.values()) {
            String bundleVersion = b.Manifest.getVersionAsString();
            if (v == null) {
                v = bundleVersion;
                continue;
            }
            if (v.equals(bundleVersion)) continue;
            return "";
        }
        if (v == null) {
            return "";
        }
        return v;
    }
}

