/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractScoutWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.widgets.Display;

public class AbstractWorkspaceWizard
extends AbstractWizard {
    public AbstractWorkspaceWizard() {
        super(new AbstractScoutWizardPage[0]);
    }

    @Override
    public void addPage(IWizardPage page) {
        if (!(page instanceof AbstractWorkspaceWizardPage)) {
            throw new IllegalArgumentException("Expecting an instance of '" + AbstractWorkspaceWizardPage.class.getName() + "'.");
        }
        super.addPage(page);
    }

    @Override
    public final boolean performFinish() {
        block3: {
            try {
                if (this.beforeFinish()) break block3;
                ScoutSdkUi.logInfo("Wizard '" + this.getWindowTitle() + "' before finish canceled.");
                return false;
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("Wizard finished abnormally", e);
                return false;
            }
        }
        P_PerformFinishOperation performFinishOperation = new P_PerformFinishOperation(this.getShell().getDisplay());
        OperationJob job = new OperationJob(new IOperation[]{performFinishOperation});
        job.schedule();
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            boolean validPage = false;
            AbstractWorkspaceWizardPage bcPage = (AbstractWorkspaceWizardPage)page;
            try {
                validPage = bcPage.performFinish(monitor, workingCopyManager);
            }
            catch (Exception e) {
                ScoutSdkUi.logError("exception during perfoming finish on wizard page '" + page.getClass().getName() + "'.", e);
                return false;
            }
            if (!validPage) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void postFinishDisplayThread() {
    }

    protected boolean beforeFinish() throws CoreException {
        return true;
    }

    private class P_PerformFinishOperation
    implements IOperation {
        private final Display m_display;

        private P_PerformFinishOperation(Display display) {
            this.m_display = display;
        }

        public String getOperationName() {
            return AbstractWorkspaceWizard.this.getWindowTitle();
        }

        public void validate() throws IllegalArgumentException {
        }

        public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
            try {
                AbstractWorkspaceWizard.this.performFinish(monitor, workingCopyManager);
                this.m_display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractWorkspaceWizard.this.postFinishDisplayThread();
                    }
                });
            }
            catch (Exception e) {
                ScoutSdkUi.logError("exception during perfoming finish on wizard page '" + ((Object)((Object)AbstractWorkspaceWizard.this)).getClass().getName() + "'.", e);
            }
        }
    }
}

