/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.smartfield;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.field.SmartFieldNewOperation;
import org.eclipse.scout.sdk.operation.form.formdata.FormDataUtility;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SmartFieldNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iSmartField = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField");
    final IType abstractSmartField = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField");
    final IType iLookupCall = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.LookupCall");
    final IType iCodeType = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType");
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private String m_genericSignature;
    private IType m_codeType;
    private IType m_lookupCall;
    private SiblingProposal m_sibling;
    private boolean m_codeTypeDefinesGenericType;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_codeTypeField;
    private ProposalTextField m_lookupCallField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private IType m_createdField;

    public SmartFieldNewWizardPage(IType declaringType) {
        super(SmartFieldNewWizardPage.class.getName());
        this.m_declaringType = declaringType;
        this.setSuperType(this.abstractSmartField);
        this.m_genericSignature = Signature.createTypeSignature((String)Long.class.getName(), (boolean)true);
        this.m_sibling = SiblingProposal.SIBLING_END;
        this.m_codeTypeDefinesGenericType = false;
    }

    @Override
    protected void createContent(Composite parent) {
        this.setTitle(Texts.get((String)"NewSmartField"));
        this.setDescription(Texts.get((String)"CreateANewSmartField"));
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"Name"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SmartFieldNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = SmartFieldNewWizardPage.this.getNlsName();
                    SmartFieldNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (SmartFieldNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(SmartFieldNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)SmartFieldNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        SmartFieldNewWizardPage.this.m_typeNameField.setText(SmartFieldNewWizardPage.this.m_nlsName.getKey());
                    }
                }
                finally {
                    SmartFieldNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Field");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SmartFieldNewWizardPage.this.m_typeName = SmartFieldNewWizardPage.this.m_typeNameField.getText();
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField(parent, Texts.get((String)"GenericType"), ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType), SignatureProposalProvider.DEFAULT_MOST_USED);
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SmartFieldNewWizardPage.this.m_genericSignature = (String)event.proposal;
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_codeTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"CodeType"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                return new Object[][]{ScoutTypeUtility.getClassesOnClasspath((IType)SmartFieldNewWizardPage.this.iCodeType, (IJavaProject)SmartFieldNewWizardPage.this.m_declaringType.getJavaProject())};
            }
        });
        this.m_codeTypeField.acceptProposal(this.getCodeType());
        this.m_codeTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                block6: {
                    try {
                        SmartFieldNewWizardPage.this.m_codeType = (IType)event.proposal;
                        SmartFieldNewWizardPage.this.m_lookupCallField.acceptProposal(null);
                        SmartFieldNewWizardPage.this.m_lookupCallField.setEnabled(SmartFieldNewWizardPage.this.m_codeType == null);
                        SmartFieldNewWizardPage.this.m_codeTypeDefinesGenericType = false;
                        if (!TypeUtility.exists((IJavaElement)SmartFieldNewWizardPage.this.m_codeType)) break block6;
                        try {
                            String s = FormDataUtility.computeFormFieldGenericType((IType)SmartFieldNewWizardPage.this.m_codeType, (ITypeHierarchy)TypeUtility.getSuperTypeHierarchy((IType)SmartFieldNewWizardPage.this.m_codeType));
                            if (s != null) {
                                SmartFieldNewWizardPage.this.m_codeTypeDefinesGenericType = true;
                                SmartFieldNewWizardPage.this.m_genericSignature = s;
                                SmartFieldNewWizardPage.this.m_genericTypeField.acceptProposal(SmartFieldNewWizardPage.this.getGenericSignature());
                            }
                        }
                        catch (JavaModelException e) {
                            ScoutSdkUi.logError("failed to get generic type of code type '" + SmartFieldNewWizardPage.this.m_codeType.getElementName() + "'.", e);
                        }
                    }
                    finally {
                        SmartFieldNewWizardPage.this.setStateChanging(false);
                    }
                }
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_lookupCallField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"LookupCall"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                return new Object[][]{ScoutTypeUtility.getClassesOnClasspath((IType)SmartFieldNewWizardPage.this.iLookupCall, (IJavaProject)SmartFieldNewWizardPage.this.m_declaringType.getJavaProject())};
            }
        });
        this.m_lookupCallField.acceptProposal(this.getLookupCall());
        this.m_lookupCallField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SmartFieldNewWizardPage.this.setStateChanging(true);
                    SmartFieldNewWizardPage.this.m_lookupCall = (IType)event.proposal;
                    SmartFieldNewWizardPage.this.m_codeTypeField.acceptProposal(null);
                    SmartFieldNewWizardPage.this.m_codeTypeField.setEnabled(SmartFieldNewWizardPage.this.m_lookupCall == null);
                }
                finally {
                    SmartFieldNewWizardPage.this.setStateChanging(false);
                }
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createFormFieldSiblingProposalField(parent, this.m_declaringType);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SmartFieldNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                SmartFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_sibling = (SiblingProposal)this.m_siblingField.getSelectedProposal();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_codeTypeField.setLayoutData(new GridData(768));
        this.m_lookupCallField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SmartFieldNewOperation operation = new SmartFieldNewOperation(this.m_declaringType, true);
        operation.setFormatSource(true);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName());
        }
        operation.setTypeName(this.getTypeName());
        if (this.getSuperType() != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? Signature.createTypeSignature((String)(String.valueOf(this.getSuperType().getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature()) + ">"), (boolean)true) : Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName(), (boolean)true);
            operation.setSuperTypeSignature(sig);
        }
        operation.setCodeType(this.getCodeType());
        operation.setLookupCall(this.getLookupCall());
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredCompositeField((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else {
            operation.setSibling(this.getSibling().getElement());
        }
        operation.run(monitor, workingCopyManager);
        this.m_createdField = operation.getCreatedField();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusGenericType());
            if (this.isControlCreated()) {
                this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()) && !this.m_codeTypeDefinesGenericType);
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Field")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_fieldNull"));
        }
        if (ScoutTypeUtility.getAllTypes((ICompilationUnit)this.m_declaringType.getCompilationUnit(), (ITypeFilter)TypeFilters.getRegexSimpleNameFilter((String)this.getTypeName())).length > 0) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusGenericType() throws JavaModelException {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IType getCreatedField() {
        return this.m_createdField;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public void setGenericSignature(String genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericSignature() {
        return this.m_genericSignature;
    }

    public void setCodeType(IType codeType) {
        try {
            this.setStateChanging(true);
            this.m_codeType = codeType;
            if (this.isControlCreated()) {
                this.m_codeTypeField.acceptProposal(codeType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getCodeType() {
        return this.m_codeType;
    }

    public void setLookupCall(IType lookupCall) {
        try {
            this.setStateChanging(true);
            this.m_lookupCall = lookupCall;
            if (this.isControlCreated()) {
                this.m_codeTypeField.acceptProposal(lookupCall);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getLookupCall() {
        return this.m_lookupCall;
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

