/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.handler;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.FormHandlerNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.handler.FormHandlerNewWizardPage1;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormHandlerNewWizardPage2
extends AbstractWorkspaceWizardPage {
    final IType iFormHandler = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IFormHandler");
    private String m_typeName;
    private StyledTextField m_typeNameField;
    private final IType m_declaringType;
    private IType m_createdFormHandler;

    public FormHandlerNewWizardPage2(IType declaringType) {
        super(FormHandlerNewWizardPage2.class.getName());
        this.setTitle(Texts.get((String)"NewFormHandler"));
        this.setDescription(Texts.get((String)"CreateANewCalendarFormHandler"));
        this.m_declaringType = declaringType;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Handler");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormHandlerNewWizardPage2.this.m_typeName = FormHandlerNewWizardPage2.this.m_typeNameField.getText();
                FormHandlerNewWizardPage2.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        FormHandlerNewOperation operation = new FormHandlerNewOperation(this.getDeclaringType());
        operation.setFormatSource(true);
        operation.setTypeName(this.getTypeName());
        FormHandlerNewWizardPage1 previousPage = (FormHandlerNewWizardPage1)this.getWizard().getPreviousPage((IWizardPage)this);
        if (previousPage.getSelectedSuperType() != null) {
            operation.setSuperTypeSignature(Signature.createTypeSignature((String)previousPage.getSelectedSuperType().getFullyQualifiedName(), (boolean)true));
        }
        IStructuredType structuredType = ScoutTypeUtility.createStructuredForm((IType)this.m_declaringType);
        operation.setSibling(structuredType.getSiblingTypeFormHandler(this.getTypeName()));
        operation.setStartMethodSibling(structuredType.getSiblingMethodStartHandler(operation.getStartMethodName()));
        operation.run(monitor, workingCopyManager);
        this.m_createdFormHandler = operation.getCreatedHandler();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Handler")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.exists((IJavaElement)this.getDeclaringType().getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    public IType getCreatedFormHandler() {
        return this.m_createdFormHandler;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }
}

