/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.page;

import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.page.PageNewAttributesWizardPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PageNewTemplatesWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iPage = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage");
    private FilteredTable m_filteredTable;
    private IType m_selectedType;
    private IScoutBundle m_clientBundle;

    public PageNewTemplatesWizardPage(IScoutBundle clientBundle) {
        super(PageNewTemplatesWizardPage.class.getName());
        this.setTitle(Texts.get((String)"PageTemplates"));
        this.setDescription(Texts.get((String)"ChooseATemplateForYourPage"));
        this.m_clientBundle = clientBundle;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_filteredTable = new FilteredTable(parent, 68100);
        this.m_filteredTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    PageNewTemplatesWizardPage.this.m_selectedType = (IType)selection.getFirstElement();
                    PageNewTemplatesWizardPage.this.pingStateChanging();
                }
            }
        });
        this.m_filteredTable.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    PageNewTemplatesWizardPage.this.m_selectedType = (IType)selection.getFirstElement();
                    PageNewTemplatesWizardPage.this.pingStateChanging();
                    IWizardPage page = PageNewTemplatesWizardPage.this.getNextPage();
                    if (page == null) {
                        return;
                    }
                    IWizardContainer container = PageNewTemplatesWizardPage.this.getWizard().getContainer();
                    if (container != null) {
                        container.showPage(page);
                    }
                }
            }
        });
        IPrimaryTypeTypeHierarchy hierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iPage);
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getClientBundle().getJavaProject()), TypeFilters.getFlagsFilter((int)1024)});
        IType[] abstractPages = hierarchy.getAllSubtypes(this.iPage, filter, TypeComparators.getTypeNameComparator());
        P_TableContentProvider provider = new P_TableContentProvider(abstractPages);
        this.m_filteredTable.getViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_filteredTable.getViewer().setContentProvider((IContentProvider)provider);
        this.m_filteredTable.getViewer().setInput((Object)provider);
        this.updateUi();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_filteredTable.setLayoutData(new GridData(1808));
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        if (this.getSelectedType() != null) {
            multiStatus.add(Status.OK_STATUS);
        } else {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ATemplateMustBeSelected")));
        }
        PageNewAttributesWizardPage page = (PageNewAttributesWizardPage)this.getWizard().getPage(PageNewAttributesWizardPage.class.getName());
        if (page != null) {
            page.setSuperType(this.getSelectedType());
        }
    }

    protected void updateUi() {
        if (this.getClientBundle() != null) {
            HashSet<IType> templates = new HashSet<IType>();
            IType[] iTypeArray = ScoutTypeUtility.getAbstractTypesOnClasspath((IType)this.iPage, (IJavaProject)this.getClientBundle().getJavaProject());
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType t = iTypeArray[n2];
                if (!templates.contains(t)) {
                    templates.add(t);
                }
                ++n2;
            }
            P_TableContentProvider provider = new P_TableContentProvider(templates.toArray(new IType[templates.size()]));
            this.m_filteredTable.getViewer().setLabelProvider((IBaseLabelProvider)provider);
            this.m_filteredTable.getViewer().setContentProvider((IContentProvider)provider);
            this.m_filteredTable.getViewer().setInput((Object)provider);
            this.m_filteredTable.getViewer().refresh();
        } else {
            P_TableContentProvider provider = new P_TableContentProvider(new IType[0]);
            this.m_filteredTable.getViewer().setLabelProvider((IBaseLabelProvider)provider);
            this.m_filteredTable.getViewer().setContentProvider((IContentProvider)provider);
            this.m_filteredTable.getViewer().setInput((Object)provider);
            this.m_filteredTable.getViewer().refresh();
        }
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public void setClientBundle(IScoutBundle clientBundle) {
        try {
            this.setStateChanging(true);
            this.m_clientBundle = clientBundle;
            if (this.isControlCreated()) {
                this.updateUi();
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setSuperType(IType selectedType) {
        IStructuredContentProvider prov = (IStructuredContentProvider)this.m_filteredTable.getViewer().getContentProvider();
        Object[] objectArray = prov.getElements(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object row = objectArray[n2];
            if (((IType)row).equals(selectedType)) {
                this.m_filteredTable.getViewer().setSelection((ISelection)new StructuredSelection((Object)selectedType));
            }
            ++n2;
        }
        this.pingStateChanging();
    }

    public IType getSelectedType() {
        return this.m_selectedType;
    }

    private class P_TableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        IType[] m_templates;

        private P_TableContentProvider(IType[] templates) {
            this.m_templates = templates;
        }

        public Object[] getElements(Object inputElement) {
            return this.m_templates;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ScoutSdkUi.getImage("class_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((IType)element).getElementName();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

