/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ServiceNewWizardPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class CustomServiceNewWizard
extends AbstractWorkspaceWizard {
    public static final int TYPE_SERVICE_INTERFACE = 107;
    public static final int TYPE_SERVICE_IMPLEMENTATION = 108;
    public static final int TYPE_SERVICE_REG_CLIENT = 109;
    public static final int TYPE_SERVICE_REG_SERVER = 110;
    private ServiceNewWizardPage m_serviceNewWizardPage;
    private BundleTreeWizardPage m_locationWizardPage;
    private ITreeNode m_locationWizardPageRoot;
    private ServiceNewOperation m_operation = new ServiceNewOperation();
    private final String m_customAppendix;

    public CustomServiceNewWizard(IScoutBundle serverBundle, IPackageFragment implPackage) {
        this.setWindowTitle(Texts.get((String)"NewCustomService"));
        IScoutBundle bundle = ScoutTypeUtility.getScoutBundle((IJavaElement)implPackage);
        this.m_customAppendix = implPackage.getElementName().replaceFirst(String.valueOf(bundle.getPackageName(".services.custom")) + ".", "");
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_serviceNewWizardPage = new ServiceNewWizardPage(Texts.get((String)"NewCustomService"), Texts.get((String)"CreateANewCustomService"), TypeUtility.getType((String)"org.eclipse.scout.service.IService"), "Service");
        this.m_serviceNewWizardPage.setLocationBundle(serverBundle);
        this.m_serviceNewWizardPage.addStatusProvider(statusProvider);
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        this.m_locationWizardPageRoot = this.createTree(serverBundle);
        this.m_locationWizardPage = new BundleTreeWizardPage(Texts.get((String)"CustomServiceLocation"), Texts.get((String)"OrganiseLocations"), this.m_locationWizardPageRoot, new P_InitialCheckerFilter());
        this.m_locationWizardPage.addStatusProvider(statusProvider);
        this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_locationWizardPage);
        this.m_serviceNewWizardPage.setSuperType(TypeUtility.getType((String)"org.eclipse.scout.service.AbstractService"));
    }

    private ITreeNode createTree(IScoutBundle serverBundle) {
        IScoutBundle sharedBundle = null;
        IScoutBundle clientBundle = null;
        IScoutProject scoutProject = serverBundle.getScoutProject();
        while ((sharedBundle == null || clientBundle == null) && scoutProject != null) {
            sharedBundle = scoutProject.getSharedBundle();
            clientBundle = scoutProject.getClientBundle();
            scoutProject = scoutProject.getParentProject();
        }
        ITreeNode rootNode = TreeUtility.createBundleTree(serverBundle.getScoutProject(), NodeFilters.getAcceptAll());
        if (clientBundle != null) {
            ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
            TreeUtility.createNode(clientNode, 109, Texts.get((String)"ServiceProxyRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 109L);
        }
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, 107, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 107L);
        }
        ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
        TreeUtility.createNode(serverNode, 108, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 108L);
        TreeUtility.createNode(serverNode, 110, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 110L);
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle[] serverRegBundles;
        IScoutBundle[] regProxyLocations;
        IScoutBundle implementationBundle;
        IType superType = this.m_serviceNewWizardPage.getSuperType();
        if (superType != null) {
            this.m_operation.setServiceSuperTypeSignature(Signature.createTypeSignature((String)superType.getFullyQualifiedName(), (boolean)true));
        }
        if ((implementationBundle = this.m_locationWizardPage.getLocationBundle(108, true, true)) != null) {
            this.m_operation.setImplementationBundle(implementationBundle);
            this.m_operation.setServicePackageName(String.valueOf(implementationBundle.getPackageName(".services.custom")) + "." + this.m_customAppendix);
            this.m_operation.setServiceName(this.m_locationWizardPage.getTextOfNode(108, true, true));
        }
        IScoutBundle[] iScoutBundleArray = regProxyLocations = this.m_locationWizardPage.getLocationBundles(109, true, true);
        int n = regProxyLocations.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle cb = iScoutBundleArray[n2];
            this.m_operation.addProxyRegistrationBundle(cb);
            ++n2;
        }
        IScoutBundle[] iScoutBundleArray2 = serverRegBundles = this.m_locationWizardPage.getLocationBundles(110, true, true);
        int n3 = serverRegBundles.length;
        n = 0;
        while (n < n3) {
            IScoutBundle sb = iScoutBundleArray2[n];
            this.m_operation.addServiceRegistrationBundle(sb);
            ++n;
        }
        IScoutBundle interfaceBundle = this.m_locationWizardPage.getLocationBundle(107, true, true);
        if (interfaceBundle != null) {
            this.m_operation.setInterfaceBundle(interfaceBundle);
            this.m_operation.setServiceInterfacePackageName(String.valueOf(interfaceBundle.getPackageName(".services.custom")) + "." + this.m_customAppendix);
        }
        this.m_operation.setServiceInterfaceName(this.m_locationWizardPage.getTextOfNode(107, true, true));
        this.m_operation.setServiceInterfaceSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.service.IService", (boolean)true));
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    private class P_InitialCheckerFilter
    implements ITreeNodeFilter {
        private P_InitialCheckerFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 107: 
                case 108: 
                case 109: 
                case 110: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = CustomServiceNewWizard.this.m_serviceNewWizardPage.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    String prefix = typeName.replaceAll("Service$", "");
                    TreeUtility.findNode(CustomServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(108)).setText(String.valueOf(prefix) + "Service");
                    TreeUtility.findNode(CustomServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(107)).setText("I" + prefix + "Service");
                    CustomServiceNewWizard.this.m_locationWizardPage.refreshTree();
                }
                CustomServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
            multiStatus.add(this.getStatusTypeNames());
        }

        protected IStatus getStatusTypeNames() {
            String fqn;
            ITreeNode serviceInterfaceNode;
            String fqn2;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = CustomServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = CustomServiceNewWizard.this.m_locationWizardPage.getTreeNode(108, true, true)) != null && serviceImplementationBundle.findType(fqn2 = String.valueOf(serviceImplementationBundle.getPackageName(".services.custom")) + "." + CustomServiceNewWizard.this.m_customAppendix + "." + serviceImplNode.getText()) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            IScoutBundle serviceInterfaceBundle = CustomServiceNewWizard.this.m_locationWizardPage.getLocationBundle(107, true, true);
            if (serviceInterfaceBundle != null && (serviceInterfaceNode = CustomServiceNewWizard.this.m_locationWizardPage.getTreeNode(107, true, true)) != null && serviceInterfaceBundle.findType(fqn = String.valueOf(serviceInterfaceBundle.getPackageName(".services.custom")) + "." + CustomServiceNewWizard.this.m_customAppendix + "." + serviceInterfaceNode.getText()) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceInterfaceBundle;
            IScoutBundle serviceImplementationBundle = CustomServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null && (serviceInterfaceBundle = CustomServiceNewWizard.this.m_locationWizardPage.getLocationBundle(107, true, true)) != null && !serviceImplementationBundle.isOnClasspath(serviceInterfaceBundle)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{CustomServiceNewWizard.this.m_locationWizardPage.getTextOfNode(107), CustomServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108)}));
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = CustomServiceNewWizard.this.m_locationWizardPage.getLocationBundle(107, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = CustomServiceNewWizard.this.m_locationWizardPage.getTreeNodes(109, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceInterfaceBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{CustomServiceNewWizard.this.m_locationWizardPage.getTextOfNode(107), serviceRegistrationBundle.getBundleName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = CustomServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = CustomServiceNewWizard.this.m_locationWizardPage.getTreeNodes(110, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceImplementationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{CustomServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108), serviceRegistrationBundle.getBundleName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            switch (node.getType()) {
                case 107: 
                case 108: 
                case 109: 
                case 110: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            CustomServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 109: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }

        private void validateDropMove(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 109: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                case 107: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 4;
                    break;
                }
                case 108: 
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }
    }
}

