/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.create;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.template.CreateTemplateOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.dialog.TemplateFromFromFieldDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Shell;

public class CreateTemplateAction
extends AbstractScoutHandler {
    private IType m_type;
    private TemplateFromFromFieldDialog m_dialog;
    private IScoutBundle m_bundle;
    private String m_packageName;
    private IPage m_page;

    public CreateTemplateAction() {
        super(Texts.get((String)"CreateTemplate"), null, null, false, IScoutHandler.Category.TEMPLATE);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        String name = "Abstract" + this.getType().getElementName();
        this.m_dialog = new TemplateFromFromFieldDialog(shell, name, this.getType());
        if (this.m_dialog.open() == 0) {
            CreateTemplateOperation op = new CreateTemplateOperation(this.getType());
            op.setTemplateName(this.m_dialog.getTemplateName());
            op.setPackageName(this.m_packageName);
            op.setTemplateBundle(this.m_bundle);
            op.setReplaceFieldWithTemplate(this.m_dialog.isReplaceFormField());
            op.setCreateExternalFormData(this.m_dialog.isCreateExternalFormData());
            op.validate();
            OperationJob job = new OperationJob(new IOperation[]{op});
            job.schedule();
            try {
                job.join();
                this.m_page.markStructureDirty();
            }
            catch (InterruptedException e) {
                ScoutSdkUi.logWarning("could not wait for job '" + job.getName() + "'.", e);
            }
        }
        return null;
    }

    public IType getType() {
        return this.m_type;
    }

    public void setType(IType type) {
        this.m_type = type;
        this.m_bundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_type);
        this.m_packageName = this.m_bundle.getPackageName(".ui.template.formfield");
    }

    public void setPage(IPage page) {
        this.m_page = page;
    }
}

