/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.bundletree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TreeUtility {
    public static final int TYPE_PRODUCT_NODE = 2999;

    private TreeUtility() {
    }

    public static ITreeNode[] findNodes(ITreeNode startNode, ITreeNodeFilter filter) {
        ArrayList<ITreeNode> collector = new ArrayList<ITreeNode>(3);
        TreeUtility.collectNodes(startNode, filter, collector);
        return collector.toArray(new ITreeNode[collector.size()]);
    }

    public static ITreeNode findNode(ITreeNode startNode, ITreeNodeFilter filter) {
        ArrayList<ITreeNode> collector = new ArrayList<ITreeNode>(3);
        TreeUtility.collectNodes(startNode, filter, collector);
        if (collector.size() > 0) {
            if (collector.size() > 1) {
                ScoutSdkUi.logWarning("more than 1 node found.");
            }
            return collector.get(0);
        }
        return null;
    }

    private static void collectNodes(ITreeNode node, ITreeNodeFilter filter, List<ITreeNode> collector) {
        if (filter.accept(node)) {
            collector.add(node);
        }
        for (ITreeNode childNode : node.getChildren()) {
            TreeUtility.collectNodes(childNode, filter, collector);
        }
    }

    public static ITreeNode createBundleTree(IScoutProject scoutProject) {
        return TreeUtility.createBundleTree(scoutProject, NodeFilters.getAcceptAll());
    }

    public static ITreeNode createBundleTree(IScoutProject scoutProject, ITreeNodeFilter filter) {
        TreeNode rootNode = new TreeNode(-1, "root");
        rootNode.setVisible(false);
        while (scoutProject.getParentProject() != null) {
            scoutProject = scoutProject.getParentProject();
        }
        if (scoutProject.getClientBundle() != null) {
            TreeUtility.recAddChildNodes(rootNode, new IScoutBundle[]{scoutProject.getClientBundle()}, 3, ScoutSdkUi.getImageDescriptor("clientBundle.png"), 1000L, filter);
        }
        if (scoutProject.getSharedBundle() != null) {
            TreeUtility.recAddChildNodes(rootNode, new IScoutBundle[]{scoutProject.getSharedBundle()}, 4, ScoutSdkUi.getImageDescriptor("sharedBundle.png"), 2000L, filter);
        }
        if (scoutProject.getServerBundle() != null) {
            TreeUtility.recAddChildNodes(rootNode, new IScoutBundle[]{scoutProject.getServerBundle()}, 5, ScoutSdkUi.getImageDescriptor("serverBundle.png"), 3000L, filter);
        }
        return rootNode;
    }

    private static void recAddChildNodes(ITreeNode node, IScoutBundle[] bundles, int type, ImageDescriptor img, long orderNr, ITreeNodeFilter filter) {
        IScoutBundle[] iScoutBundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle b = iScoutBundleArray[n2];
            TreeNode childNode = new TreeNode(b.getType(), b.getBundleName(), b);
            childNode.setOrderNr(orderNr);
            childNode.setBold(true);
            childNode.setImage(img);
            if (filter.accept(childNode)) {
                node.addChild(childNode);
                childNode.setParent(node);
                TreeUtility.recAddChildNodes(childNode, b.getDependentBundles((IScoutBundleFilter)new CheckableTree.P_DependentFilter(type), false), type, img, orderNr, filter);
            }
            ++n2;
        }
    }

    public static ITreeNode createNode(ITreeNode parentNode, int type, String name, ImageDescriptor img) {
        return TreeUtility.createNode(parentNode, type, name, img, 0L);
    }

    public static ITreeNode createNode(ITreeNode parentNode, int type, String name, ImageDescriptor img, long orderNr) {
        return TreeUtility.createNode(parentNode, type, name, img, orderNr, null);
    }

    public static ITreeNode createNode(ITreeNode parentNode, int type, String name, ImageDescriptor img, long orderNr, Object data) {
        TreeNode node = new TreeNode(type, name);
        node.setData(data);
        node.setOrderNr(orderNr);
        node.setImage(img);
        node.setCheckable(true);
        node.setParent(parentNode);
        parentNode.addChild(node);
        return node;
    }

    public static ITreeNode createProductTree(IScoutProject project, ITreeNodeFilter visibleFilter, boolean checkMode) {
        if (project == null) {
            return null;
        }
        if (visibleFilter == null) {
            visibleFilter = NodeFilters.getAcceptAll();
        }
        ArrayList<P_ProductFile> productFiles = new ArrayList<P_ProductFile>();
        TreeUtility.visitScoutProject(productFiles, project);
        TreeNode rootNode = new TreeNode(-1, "root");
        rootNode.setVisible(false);
        for (P_ProductFile productFile : productFiles) {
            IScoutBundle bundle = productFile.getScoutBundle();
            IFile file = productFile.getProductFile();
            ITreeNode bundleNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(bundle));
            if (bundleNode == null) {
                bundleNode = new TreeNode(bundle.getType(), bundle.getBundleName(), bundle);
                switch (bundle.getType()) {
                    case 6: {
                        ((TreeNode)bundleNode).setImage(ScoutSdkUi.getImageDescriptor("uiBundle.png"));
                        ((TreeNode)bundleNode).setOrderNr(1000L);
                        break;
                    }
                    case 7: {
                        ((TreeNode)bundleNode).setImage(ScoutSdkUi.getImageDescriptor("uiBundle.png"));
                        ((TreeNode)bundleNode).setOrderNr(2000L);
                        break;
                    }
                    case 5: {
                        ((TreeNode)bundleNode).setImage(ScoutSdkUi.getImageDescriptor("serverBundle.png"));
                        ((TreeNode)bundleNode).setOrderNr(3000L);
                    }
                }
                bundleNode.setCheckable(false);
                if (visibleFilter.accept(bundleNode)) {
                    rootNode.addChild(bundleNode);
                } else {
                    bundleNode = null;
                }
            }
            if (bundleNode == null) continue;
            TreeNode productNode = new TreeNode(2999, String.valueOf(file.getName()) + " (" + file.getParent().getName() + ")", file);
            productNode.setCheckable(checkMode);
            productNode.setBold(true);
            IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)file.getAdapter(IWorkbenchAdapter.class);
            if (wbAdapter != null) {
                ImageDescriptor imageDescriptor = wbAdapter.getImageDescriptor((Object)file);
                productNode.setImage(imageDescriptor);
            }
            if (!visibleFilter.accept(productNode)) continue;
            bundleNode.addChild(productNode);
        }
        return rootNode;
    }

    public static IFile[] getAllProductFiles(IScoutProject project) {
        ArrayList<P_ProductFile> productFiles = new ArrayList<P_ProductFile>();
        TreeUtility.visitScoutProject(productFiles, project);
        return TreeUtility.getFiles(productFiles);
    }

    private static IFile[] getFiles(List<P_ProductFile> productFiles) {
        IFile[] ret = new IFile[productFiles.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = productFiles.get(i).getProductFile();
            ++i;
        }
        return ret;
    }

    public static IFile[] getAllProductFiles(IScoutBundle bundle) {
        ArrayList<P_ProductFile> productFiles = new ArrayList<P_ProductFile>();
        TreeUtility.visitScoutBundle(productFiles, bundle);
        return TreeUtility.getFiles(productFiles);
    }

    private static void visitScoutBundle(List<P_ProductFile> productFileCollector, IScoutBundle b) {
        try {
            b.getProject().accept((IResourceVisitor)new P_ProductResourceVisitor(b, productFileCollector));
        }
        catch (CoreException e) {
            ScoutSdkUi.logWarning("error during searching *.product in '" + b.getProject().getName() + "'.", e);
        }
    }

    private static void visitScoutProject(List<P_ProductFile> productFileCollector, IScoutProject project) {
        IScoutBundle[] iScoutBundleArray = project.getAllScoutBundles();
        int n = iScoutBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle b = iScoutBundleArray[n2];
            TreeUtility.visitScoutBundle(productFileCollector, b);
            ++n2;
        }
        iScoutBundleArray = project.getSubProjects();
        n = iScoutBundleArray.length;
        n2 = 0;
        while (n2 < n) {
            IScoutBundle childProject = iScoutBundleArray[n2];
            TreeUtility.visitScoutProject(productFileCollector, (IScoutProject)childProject);
            ++n2;
        }
    }

    private static class P_ProductFile {
        private IScoutBundle m_scoutBundle;
        private IFile m_productFile;

        public P_ProductFile(IScoutBundle bundle, IFile file) {
            this.m_scoutBundle = bundle;
            this.m_productFile = file;
        }

        public IScoutBundle getScoutBundle() {
            return this.m_scoutBundle;
        }

        public IFile getProductFile() {
            return this.m_productFile;
        }
    }

    private static class P_ProductResourceVisitor
    implements IResourceVisitor {
        private final List<P_ProductFile> m_productFileCollector;
        private final IScoutBundle m_bundle;

        private P_ProductResourceVisitor(IScoutBundle bundle, List<P_ProductFile> productFileCollector) {
            this.m_bundle = bundle;
            this.m_productFileCollector = productFileCollector;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && resource.getName().matches(".*\\.product")) {
                this.m_productFileCollector.add(new P_ProductFile(this.m_bundle, (IFile)resource));
            } else if (resource.getType() == 2) {
                return true;
            }
            return true;
        }
    }
}

