/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.jdt;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.swt.widgets.Shell;

public class JdtRenameTransaction {
    private ArrayList<RenameSupport> m_list = new ArrayList();
    private HashSet<ICompilationUnit> m_touchedCompilationUntis = new HashSet();

    public static int getDefaultFlags() {
        return 65;
    }

    public void add(ICompilationUnit e, String newName) throws CoreException {
        this.addRenameSupport(RenameSupport.create((ICompilationUnit)e, (String)newName, (int)JdtRenameTransaction.getDefaultFlags()));
        this.m_touchedCompilationUntis.add(e);
    }

    public void add(IField e, String newName) throws CoreException {
        this.addRenameSupport(RenameSupport.create((IField)e, (String)newName, (int)JdtRenameTransaction.getDefaultFlags()));
        this.m_touchedCompilationUntis.add(e.getCompilationUnit());
    }

    public void add(IJavaProject e, String newName) throws CoreException {
        this.addRenameSupport(RenameSupport.create((IJavaProject)e, (String)newName, (int)JdtRenameTransaction.getDefaultFlags()));
    }

    public void add(ILocalVariable e, String newName) throws CoreException {
        this.addRenameSupport(RenameSupport.create((ILocalVariable)e, (String)newName, (int)JdtRenameTransaction.getDefaultFlags()));
    }

    public void add(IMethod e, String newName) throws CoreException {
        this.addRenameSupport(RenameSupport.create((IMethod)e, (String)newName, (int)JdtRenameTransaction.getDefaultFlags()));
        this.m_touchedCompilationUntis.add(e.getCompilationUnit());
    }

    public void add(IPackageFragment e, String newName) throws CoreException {
        this.addRenameSupport(RenameSupport.create((IPackageFragment)e, (String)newName, (int)JdtRenameTransaction.getDefaultFlags()));
    }

    public void add(IPackageFragmentRoot e, String newName) throws CoreException {
        this.addRenameSupport(RenameSupport.create((IPackageFragmentRoot)e, (String)newName));
    }

    public void add(IType e, String newName) throws CoreException {
        this.addRenameSupport(RenameSupport.create((IType)e, (String)newName, (int)JdtRenameTransaction.getDefaultFlags()));
        this.m_touchedCompilationUntis.add(e.getCompilationUnit());
    }

    public void add(ITypeParameter e, String newName) throws CoreException {
        this.addRenameSupport(RenameSupport.create((ITypeParameter)e, (String)newName, (int)JdtRenameTransaction.getDefaultFlags()));
        this.m_touchedCompilationUntis.add(e.getDeclaringMember().getCompilationUnit());
    }

    public void addRenameSupport(RenameSupport r) {
        this.m_list.add(r);
    }

    public void commit(Shell shell) throws CoreException {
        for (RenameSupport r : this.m_list) {
            if (r.preCheck().isOK()) continue;
            throw new CoreException((IStatus)new ScoutStatus("preCheck failed"));
        }
        try {
            for (RenameSupport r : this.m_list) {
                r.perform(shell, (IRunnableContext)new ProgressMonitorDialog(shell));
            }
            for (ICompilationUnit icu : this.m_touchedCompilationUntis) {
                icu.reconcile(0, false, null, null);
            }
            this.m_touchedCompilationUntis.clear();
        }
        catch (Throwable t) {
            ScoutSdkUi.logError("rename failed.", t);
        }
    }
}

