/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ImportPluginAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutProjectNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ProjectNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.IScoutWorkspaceListener;
import org.eclipse.scout.sdk.workspace.ScoutWorkspaceEvent;

public class ProjectsTablePage
extends AbstractPage {
    private IScoutWorkspaceListener m_workspaceListener = new IScoutWorkspaceListener(){

        public void worspaceChanged(ScoutWorkspaceEvent event) {
            switch (event.getType()) {
                case 4: 
                case 5: 
                case 6: {
                    ProjectsTablePage.this.markStructureDirty();
                }
            }
        }
    };

    public ProjectsTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"RootNodeName"));
        ScoutSdkCore.getScoutWorkspace().addWorkspaceListener(this.m_workspaceListener);
    }

    @Override
    public void unloadPage() {
        ScoutSdkCore.getScoutWorkspace().removeWorkspaceListener(this.m_workspaceListener);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ProjectsTablePage";
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IScoutProject[] rootProjects = ScoutSdkCore.getScoutWorkspace().getRootProjects();
        Arrays.sort(rootProjects, 0, rootProjects.length, new Comparator<IScoutProject>(){

            @Override
            public int compare(IScoutProject o1, IScoutProject o2) {
                return o1.getProjectName().compareTo(o2.getProjectName());
            }
        });
        ScoutSdkUi.logInfo("INVISIBLE ROOT NODE: found " + rootProjects.length + " root projects.");
        IScoutProject[] iScoutProjectArray = rootProjects;
        int n = rootProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutProject group = iScoutProjectArray[n2];
            new ProjectNodePage(this, group);
            ++n2;
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{ScoutProjectNewAction.class, ImportPluginAction.class};
    }

    @Override
    public boolean isFolder() {
        return true;
    }
}

