/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.ClientServiceNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientServiceNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class ClientServiceTablePage
extends AbstractPage {
    final IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
    private ICachedTypeHierarchy m_servieHierarchy;

    public ClientServiceTablePage(IPage parentPage) {
        this.setParent(parentPage);
        this.setName(Texts.get((String)"ClientServicesNodePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("services.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_servieHierarchy != null) {
            this.m_servieHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_servieHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_servieHierarchy != null) {
            this.m_servieHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ClientServiceTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] serviceTypes;
        if (this.m_servieHierarchy == null) {
            this.m_servieHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iService);
            this.m_servieHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] iTypeArray = serviceTypes = this.m_servieHierarchy.getAllSubtypes(this.iService, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), TypeComparators.getTypeNameComparator());
        int n = serviceTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IType serviceInterface = null;
            IType[] interfaces = this.m_servieHierarchy.getSuperInterfaces(type, TypeFilters.getElementNameFilter((String)("I" + type.getElementName())));
            if (interfaces.length > 0) {
                serviceInterface = interfaces[0];
            }
            new ClientServiceNodePage(this, type, serviceInterface);
            ++n2;
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{ClientServiceNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        ((ClientServiceNewAction)menu).setScoutBundle(this.getScoutResource());
    }
}

