/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.OutlineNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class DesktopOutlineTablePage
extends AbstractPage {
    final IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    final String getConfiguredOutlines = "getConfiguredOutlines";
    private IType m_desktopType;
    private P_MethodListener m_methodListener;
    private ICachedTypeHierarchy m_outlineTypeHierarchy;

    public DesktopOutlineTablePage(IPage parentPage, IType desktopType) {
        super.setParent(parentPage);
        this.setName(Texts.get((String)"OutlineTablePage"));
        this.m_desktopType = desktopType;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("outlines.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.DesktopOutlineTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public IType getDesktopType() {
        return this.m_desktopType;
    }

    @Override
    public void unloadPage() {
        if (this.m_methodListener != null) {
            TypeCacheAccessor.getJavaResourceChangedEmitter().removeMethodChangedListener(this.getDesktopType(), (IJavaResourceChangedListener)this.m_methodListener);
            this.m_methodListener = null;
        }
        if (this.m_outlineTypeHierarchy != null) {
            this.m_outlineTypeHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_outlineTypeHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void loadChildrenImpl() {
        if (this.m_outlineTypeHierarchy == null) {
            this.m_outlineTypeHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iOutline);
            this.m_outlineTypeHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        if (this.m_methodListener == null) {
            this.m_methodListener = new P_MethodListener();
            TypeCacheAccessor.getJavaResourceChangedEmitter().addMethodChangedListener(this.getDesktopType(), (IJavaResourceChangedListener)this.m_methodListener);
        }
        try {
            IMethod outlinesMethod = TypeUtility.getMethod((IType)this.getDesktopType(), (String)"getConfiguredOutlines");
            if (outlinesMethod != null) {
                IType[] outlineCandidates;
                IType[] iTypeArray = outlineCandidates = ScoutTypeUtility.getTypeOccurenceInMethod((IMethod)outlinesMethod);
                int n = outlineCandidates.length;
                int n2 = 0;
                while (n2 < n) {
                    IType candidate = iTypeArray[n2];
                    if (this.m_outlineTypeHierarchy.isSubtype(this.iOutline, candidate)) {
                        new OutlineNodePage(this, candidate);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logError("error during loading children of '" + this.getClass().getName() + "'", e);
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{OutlineNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        ((OutlineNewAction)menu).init(this.getScoutResource(), this.getDesktopType());
    }

    private class P_MethodListener
    implements IJavaResourceChangedListener {
        private P_MethodListener() {
        }

        public void handleEvent(JdtEvent event) {
            if (event.getElement().getElementName().equals("getConfiguredOutlines")) {
                DesktopOutlineTablePage.this.markStructureDirty();
            }
        }
    }
}

