/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.MenuNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.MenuNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class MenuTablePage
extends AbstractPage {
    final IType iMenuType = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu");
    private final IType m_declaringType;
    private InnerTypePageDirtyListener m_menuChangedListener;

    public MenuTablePage(IPage parentPage, IType menuDeclaringType) {
        this.m_declaringType = menuDeclaringType;
        this.setParent(parentPage);
        this.setName(Texts.get((String)"MenuTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("menu.png"));
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_menuChangedListener != null) {
            TypeCacheAccessor.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
            this.m_menuChangedListener = null;
        }
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.MenuTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] menues;
        if (this.m_menuChangedListener == null) {
            this.m_menuChangedListener = new InnerTypePageDirtyListener(this, this.iMenuType);
            TypeCacheAccessor.getJavaResourceChangedEmitter().addInnerTypeChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
        }
        IType[] iTypeArray = menues = ScoutTypeUtility.getMenus((IType)this.getDeclaringType());
        int n = menues.length;
        int n2 = 0;
        while (n2 < n) {
            IType menu = iTypeArray[n2];
            new MenuNodePage(this, menu);
            ++n2;
        }
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof MenuNewAction) {
            MenuNewAction action = (MenuNewAction)menu;
            action.setType(this.getDeclaringType());
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{MenuNewAction.class};
    }
}

