/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom;

import java.util.Comparator;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.CustomServiceNewAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom.CustomServiceNodePage;
import org.eclipse.scout.sdk.ui.type.PackageContentChangedListener;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class CustomServicePackageNodePage
extends AbstractPage {
    final IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
    private PackageContentChangedListener m_packageContentListener;
    private IPackageFragment m_package;
    private IPrimaryTypeTypeHierarchy m_serviceHierarchy;

    public CustomServicePackageNodePage(AbstractPage parent, IPackageFragment packageFrament) {
        this.m_package = packageFrament;
        this.setParent(parent);
        this.m_packageContentListener = new PackageContentChangedListener(this, this.m_package);
        JavaCore.addElementChangedListener((IElementChangedListener)this.m_packageContentListener);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("package_obj.gif"));
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.m_packageContentListener);
        this.m_serviceHierarchy = null;
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CustomServicePackageNodePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    protected void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveServices();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType service = iTypeArray[n2];
            IType serviceInterface = null;
            IType[] interfaces = this.m_serviceHierarchy.getSuperInterfaces(service, TypeFilters.getElementNameFilter((String)("I" + service.getElementName())));
            if (interfaces.length > 0) {
                serviceInterface = interfaces[0];
            }
            new CustomServiceNodePage(this, service, serviceInterface);
            ++n2;
        }
    }

    protected IType[] resolveServices() {
        if (this.m_serviceHierarchy == null) {
            this.m_serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iService);
        }
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassFilter(), TypeFilters.getSubtypeFilter((IType)this.iService, (ITypeHierarchy)this.m_serviceHierarchy)});
        IType[] services = TypeUtility.getTypesInPackage((IPackageFragment)this.m_package, (ITypeFilter)filter, (Comparator)TypeComparators.getTypeNameComparator());
        return services;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{FormDataSqlBindingValidateAction.class, CustomServiceNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setTyperesolver(new ITypeResolver(){

                @Override
                public IType[] getTypes() {
                    return CustomServicePackageNodePage.this.resolveServices();
                }
            });
        } else if (menu instanceof CustomServiceNewAction) {
            ((CustomServiceNewAction)menu).init(this.getScoutResource(), this.m_package);
        }
    }
}

