/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.SearchRangeStyledLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ButtonDisplayStylePresenter
extends AbstractProposalPresenter<ButtonStyle> {
    public ButtonDisplayStylePresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        SearchRangeStyledLabelProvider labelProvider = new SearchRangeStyledLabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                return ScoutSdkUi.getImage("default.gif");
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])ButtonStyle.values(), labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    @Override
    protected ButtonStyle parseInput(String input) throws CoreException {
        int parsedInt = PropertyMethodSourceUtility.parseReturnParameterInteger((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        switch (parsedInt) {
            case 0: {
                return ButtonStyle.Default;
            }
            case 1: {
                return ButtonStyle.Toggle;
            }
            case 2: {
                return ButtonStyle.Radio;
            }
            case 3: {
                return ButtonStyle.Link;
            }
        }
        return null;
    }

    @Override
    protected synchronized void storeValue(ButtonStyle value) {
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((ButtonStyle)((Object)this.getDefaultValue()), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            String sourceValue = null;
            if (value == null) {
                sourceValue = "DISPLAY_STYLE_DEFAULT";
            } else {
                switch (value) {
                    case Default: {
                        sourceValue = "DISPLAY_STYLE_DEFAULT";
                        break;
                    }
                    case Toggle: {
                        sourceValue = "DISPLAY_STYLE_TOGGLE";
                        break;
                    }
                    case Radio: {
                        sourceValue = "DISPLAY_STYLE_RADIO";
                        break;
                    }
                    case Link: {
                        sourceValue = "DISPLAY_STYLE_LINK";
                    }
                }
            }
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + sourceValue + ";", true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }

    protected static enum ButtonStyle {
        Default,
        Toggle,
        Radio,
        Link;

    }
}

