/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.text.DecimalFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.widgets.Composite;

public class DoublePresenter
extends AbstractValuePresenter<Double> {
    public DoublePresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[-+0-9\\.\\,\\'eEinfd]*");
    }

    @Override
    protected String formatSourceValue(Double value) throws CoreException {
        if (value == null) {
            return "null";
        }
        if (value == Double.MAX_VALUE) {
            return "Double.MAX_VALUE";
        }
        if (value == -1.7976931348623157E308) {
            return "-Double.MAX_VALUE";
        }
        String sourceVal = value.toString();
        return sourceVal;
    }

    @Override
    protected String formatDisplayValue(Double value) throws CoreException {
        if (value == null) {
            return "";
        }
        if (value == Double.MAX_VALUE) {
            return "inf";
        }
        if (value == -1.7976931348623157E308) {
            return "-inf";
        }
        return DecimalFormat.getInstance().format(value);
    }

    @Override
    protected Double parseSourceInput(String input) throws CoreException {
        return this.parseDisplayInput(input);
    }

    @Override
    protected Double parseDisplayInput(String input) throws CoreException {
        if (input.equals("")) {
            return (Double)this.getDefaultValue();
        }
        Double d = PropertyMethodSourceUtility.parseReturnParameterDouble((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        return d;
    }

    @Override
    protected synchronized void storeValue(Double value) throws CoreException {
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((Double)this.getDefaultValue(), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            String sourceValue = this.formatSourceValue(value);
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + sourceValue + ";", true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }
}

