/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.dialog.FontDialog;
import org.eclipse.scout.sdk.ui.internal.dialog.FontSpec;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FontPresenter
extends AbstractValuePresenter<FontSpec> {
    private Font m_currentFont;
    private Font m_defaultFont;
    private Button m_chooserButton;

    public FontPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, ".*");
    }

    @Override
    public void dispose() {
        if (this.m_currentFont != null) {
            this.m_currentFont.dispose();
        }
        super.dispose();
    }

    @Override
    protected Control createContent(Composite container) {
        Composite rootPane = this.getToolkit().createComposite(container);
        Control text = super.createContent(rootPane);
        this.m_chooserButton = this.getToolkit().createButton(rootPane, "", 8);
        this.m_chooserButton.setImage(ScoutSdkUi.getImage("magnifier.png"));
        this.m_chooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontPresenter.this.showFontDialog();
            }
        });
        GridLayout gLayout = new GridLayout(3, false);
        gLayout.horizontalSpacing = 3;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        rootPane.setLayout((Layout)gLayout);
        text.setLayoutData((Object)new GridData(768));
        this.m_chooserButton.setLayoutData((Object)new GridData(22, 22));
        this.m_defaultFont = this.getTextComponent().getFont();
        return rootPane;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_chooserButton.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_chooserButton.getEnabled() && super.isEnabled();
        }
        return false;
    }

    @Override
    protected void execCurrentSourceValueChanged(FontSpec value) {
        if (this.m_currentFont != null) {
            this.m_currentFont.dispose();
            this.m_currentFont = null;
        }
        if (value != null) {
            FontData data = this.m_defaultFont.getFontData()[0];
            data = new FontData(data.getName(), data.getHeight(), data.getStyle());
            if (value.getName() != null) {
                data.setName(value.getName());
            }
            if (value.getStyle() != null) {
                data.setStyle(value.getStyle().intValue());
            }
            if (value.getHeight() != null) {
                data.setHeight(value.getHeight().intValue());
            }
            this.m_currentFont = new Font((Device)this.getContainer().getDisplay(), data);
        }
        this.getTextComponent().setFont(this.m_currentFont);
    }

    private void showFontDialog() {
        FontDialog fontDialog = new FontDialog(this.getContainer().getShell(), (FontSpec)this.getCurrentSourceValue());
        FontSpec fontSpec = fontDialog.openDialog();
        if (fontSpec != null) {
            try {
                if (!CompareUtility.equals((Object)((FontSpec)this.getCurrentSourceValue()), (Object)fontSpec)) {
                    this.storeValue(fontSpec);
                }
            }
            catch (CoreException e1) {
                ScoutSdkUi.logWarning("could not parse FontData: " + fontSpec, e1);
            }
        }
    }

    @Override
    protected FontSpec parseSourceInput(String input) throws CoreException {
        String value = PropertyMethodSourceUtility.parseReturnParameterString((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        if (value == null) {
            value = "";
        }
        return this.parseDisplayInput(value);
    }

    @Override
    protected FontSpec parseDisplayInput(String input) throws CoreException {
        FontSpec fontSpec = new FontSpec();
        StringTokenizer tok = new StringTokenizer(input, "-_,/.;");
        while (tok.hasMoreTokens()) {
            String nextToken = tok.nextToken();
            String s = nextToken.toUpperCase();
            if (s.equals("PLAIN")) {
                fontSpec.addStyle(0);
                continue;
            }
            if (s.equals("BOLD")) {
                fontSpec.addStyle(1);
                continue;
            }
            if (s.equals("ITALIC")) {
                fontSpec.addStyle(2);
                continue;
            }
            try {
                int size = Integer.parseInt(s);
                fontSpec.setHeight(size);
            }
            catch (NumberFormatException numberFormatException) {
                fontSpec.setName(nextToken);
            }
        }
        return fontSpec;
    }

    @Override
    protected String formatSourceValue(FontSpec value) throws CoreException {
        if (value == null || value.isDefault()) {
            return "null";
        }
        StringBuilder sourceBuilder = new StringBuilder();
        if (value.getStyle() != null) {
            if ((value.getStyle() & 1) != 0) {
                if (sourceBuilder.length() > 0) {
                    sourceBuilder.append("-");
                }
                sourceBuilder.append("BOLD");
            }
            if ((value.getStyle() & 2) != 0) {
                if (sourceBuilder.length() > 0) {
                    sourceBuilder.append("-");
                }
                sourceBuilder.append("ITALIC");
            }
            if (sourceBuilder.length() == 0) {
                sourceBuilder.append("PLAIN");
            }
        }
        if (value.getHeight() != null) {
            if (sourceBuilder.length() > 0) {
                sourceBuilder.append("-");
            }
            sourceBuilder.append(value.getHeight());
        }
        if (value.getName() != null) {
            if (sourceBuilder.length() > 0) {
                sourceBuilder.append("-");
            }
            sourceBuilder.append(value.getName());
        }
        return "\"" + sourceBuilder.toString() + "\"";
    }

    @Override
    protected String formatDisplayValue(FontSpec value) throws CoreException {
        if (value == null || value.isDefault()) {
            return "";
        }
        String displayValue = this.formatSourceValue(value);
        displayValue = displayValue.replaceAll("^\\\"(.*)\\\"$", "$1");
        return displayValue;
    }

    @Override
    protected synchronized void storeValue(FontSpec value) throws CoreException {
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((FontSpec)this.getDefaultValue(), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + this.formatSourceValue(value) + ";", true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }
}

