/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.FormStackNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.form.FormNewWizardPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class FormNewWizard
extends AbstractWorkspaceWizard {
    public static final int TYPE_FORM = 100;
    public static final int TYPE_FORM_BUTTON_OK = 101;
    public static final int TYPE_FORM_BUTTON_CANCEL = 102;
    public static final int TYPE_HANDLER_MODIFY = 110;
    public static final int TYPE_HANDLER_NEW = 111;
    public static final int TYPE_FORM_DATA = 130;
    public static final int TYPE_PERMISSION_CREATE = 140;
    public static final int TYPE_PERMISSION_READ = 143;
    public static final int TYPE_PERMISSION_UPDATE = 146;
    public static final int TYPE_SERVICE_INTERFACE = 200;
    public static final int TYPE_SERVICE_IMPLEMENTATION = 210;
    public static final int TYPE_SERVICE_REG_CLIENT = 230;
    public static final int TYPE_SERVICE_REG_SERVER = 240;
    private final IScoutBundle m_clientBundle;
    private FormNewWizardPage m_formPage;
    private BundleTreeWizardPage m_locationPage;
    private FormStackNewOperation m_operation = new FormStackNewOperation(true);
    private ITreeNode m_locationPageRoot;

    public FormNewWizard(IScoutBundle clientBundle) {
        this.setWindowTitle(Texts.get((String)"NewForm"));
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_clientBundle = clientBundle;
        this.m_formPage = new FormNewWizardPage(this.getClientBundle());
        this.addPage((IWizardPage)this.m_formPage);
        this.m_locationPageRoot = this.createTree(clientBundle);
        this.m_locationPage = new BundleTreeWizardPage(Texts.get((String)"FormClassLocations"), Texts.get((String)"OrganiseLocations"), this.m_locationPageRoot, new P_InitialCheckedFilter());
        this.m_locationPage.addStatusProvider(statusProvider);
        this.m_locationPage.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_locationPage);
        this.m_formPage.addPropertyChangeListener(new P_LocationPropertyListener());
    }

    private ITreeNode createTree(IScoutBundle clientBundle) {
        IScoutBundle sharedBundle = null;
        IScoutBundle serverBundle = null;
        IScoutProject scoutProject = clientBundle.getScoutProject();
        while ((sharedBundle == null || serverBundle == null) && scoutProject != null) {
            sharedBundle = scoutProject.getSharedBundle();
            serverBundle = scoutProject.getServerBundle();
            scoutProject = scoutProject.getParentProject();
        }
        ITreeNode rootNode = TreeUtility.createBundleTree(clientBundle.getScoutProject(), NodeFilters.getAcceptAll());
        ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(this.getClientBundle()));
        ITreeNode formNode = TreeUtility.createNode(clientNode, 100, Texts.get((String)"Form"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 100L);
        formNode.setEnabled(false);
        TreeUtility.createNode(formNode, 101, Texts.get((String)"OkButton"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 101L);
        TreeUtility.createNode(formNode, 102, Texts.get((String)"CancelButton"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 102L);
        TreeUtility.createNode(formNode, 111, Texts.get((String)"NewHandler"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 111L);
        TreeUtility.createNode(formNode, 110, Texts.get((String)"ModifyHandler"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 110L);
        if (sharedBundle != null && serverBundle != null) {
            TreeUtility.createNode(clientNode, 230, Texts.get((String)"ServiceProxyRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 230L);
        }
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, 130, Texts.get((String)"FormData"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 130L);
            TreeUtility.createNode(sharedNode, 140, Texts.get((String)"CreatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 140L);
            TreeUtility.createNode(sharedNode, 143, Texts.get((String)"ReadPermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 143L);
            TreeUtility.createNode(sharedNode, 146, Texts.get((String)"UpdatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 146L);
            if (serverBundle != null) {
                TreeUtility.createNode(sharedNode, 200, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 200L);
            }
        }
        if (serverBundle != null) {
            ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
            TreeUtility.createNode(serverNode, 210, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 210L);
            TreeUtility.createNode(serverNode, 240, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 240L);
        }
        return rootNode;
    }

    public FormNewWizardPage getFormNewPage() {
        return this.m_formPage;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        this.m_formPage.fillOperation(this.m_operation);
        this.m_operation.setCreateButtonOk(this.m_locationPage.getTreeNode(101, true, true) != null);
        this.m_operation.setCreateButtonCancel(this.m_locationPage.getTreeNode(102, true, true) != null);
        this.m_operation.setCreateModifyHandler(this.m_locationPage.getTreeNode(110, true, true) != null);
        this.m_operation.setCreateNewHandler(this.m_locationPage.getTreeNode(111, true, true) != null);
        this.m_operation.setFormBundle(this.m_locationPage.getLocationBundle(100, true, true));
        this.m_operation.setFormDataBundle(this.m_locationPage.getLocationBundle(130, true, true));
        this.m_operation.setClientServiceRegistryBundles(this.m_locationPage.getLocationBundles(230, true, true));
        this.m_operation.setPermissionCreateBundle(this.m_locationPage.getLocationBundle(140, true, true));
        this.m_operation.setPermissionCreateName(this.m_locationPage.getTextOfNode(140, true, true));
        this.m_operation.setPermissionReadBundle(this.m_locationPage.getLocationBundle(143, true, true));
        this.m_operation.setPermissionReadName(this.m_locationPage.getTextOfNode(143, true, true));
        this.m_operation.setPermissionUpdateBundle(this.m_locationPage.getLocationBundle(146, true, true));
        this.m_operation.setPermissionUpdateName(this.m_locationPage.getTextOfNode(146, true, true));
        this.m_operation.setServerServiceRegistryBundles(this.m_locationPage.getLocationBundles(240, true, true));
        this.m_operation.setServiceImplementationBundle(this.m_locationPage.getLocationBundle(210, true, true));
        this.m_operation.setServiceImplementationName(this.m_locationPage.getTextOfNode(210, true, true));
        this.m_operation.setServiceInterfaceBundle(this.m_locationPage.getLocationBundle(200, true, true));
        this.m_operation.setServiceInterfaceName(this.m_locationPage.getTextOfNode(200, true, true));
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("exception during perfoming finish of wizard.", e);
            return false;
        }
    }

    public FormNewWizardPage getFormPage() {
        return this.m_formPage;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    private class P_InitialCheckedFilter
    implements ITreeNodeFilter {
        private P_InitialCheckedFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 3: 
                case 4: 
                case 5: 
                case 100: 
                case 101: 
                case 102: 
                case 110: 
                case 111: 
                case 130: 
                case 140: 
                case 143: 
                case 146: 
                case 200: 
                case 210: 
                case 230: 
                case 240: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = FormNewWizard.this.m_formPage.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    ITreeNode serviceInterfaceNode;
                    ITreeNode serviceImplNode;
                    ITreeNode permissionUpdateNode;
                    ITreeNode permissionReadNode;
                    ITreeNode permissionCreateNode;
                    String prefix = typeName.replaceAll("Form$", "");
                    TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(100)).setText(String.valueOf(prefix) + "Form");
                    ITreeNode formDataNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(130));
                    if (formDataNode != null) {
                        formDataNode.setText(String.valueOf(prefix) + "FormData");
                    }
                    if ((permissionCreateNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(140))) != null) {
                        permissionCreateNode.setText("Create" + prefix + "Permission");
                    }
                    if ((permissionReadNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(143))) != null) {
                        permissionReadNode.setText("Read" + prefix + "Permission");
                    }
                    if ((permissionUpdateNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(146))) != null) {
                        permissionUpdateNode.setText("Update" + prefix + "Permission");
                    }
                    if ((serviceImplNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(210))) != null) {
                        serviceImplNode.setText(String.valueOf(prefix) + "ProcessService");
                    }
                    if ((serviceInterfaceNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(200))) != null) {
                        serviceInterfaceNode.setText("I" + prefix + "ProcessService");
                    }
                    FormNewWizard.this.m_locationPage.refreshTree();
                }
                FormNewWizard.this.m_locationPage.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusForm());
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
            multiStatus.add(this.getStatusTypeNames());
        }

        protected IStatus getStatusTypeNames() {
            String fqn;
            IType interfaceType;
            ITreeNode serviceInterfaceNode;
            String fqn2;
            IType findType;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = FormNewWizard.this.m_locationPage.getLocationBundle(210, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = FormNewWizard.this.m_locationPage.getTreeNode(210, true, true)) != null && (findType = serviceImplementationBundle.findType(fqn2 = String.valueOf(serviceImplementationBundle.getPackageName(".services.process")) + "." + serviceImplNode.getText())) != null && findType.exists()) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            IScoutBundle serviceInterfaceBundle = FormNewWizard.this.m_locationPage.getLocationBundle(200, true, true);
            if (serviceInterfaceBundle != null && (serviceInterfaceNode = FormNewWizard.this.m_locationPage.getTreeNode(200, true, true)) != null && (interfaceType = serviceInterfaceBundle.findType(fqn = String.valueOf(serviceInterfaceBundle.getPackageName(".services.process")) + "." + serviceInterfaceNode.getText())) != null && interfaceType.exists()) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            IStatus createStatus = this.getStatusPermission(140);
            if (createStatus != Status.OK_STATUS) {
                return createStatus;
            }
            IStatus readStatus = this.getStatusPermission(143);
            if (readStatus != Status.OK_STATUS) {
                return readStatus;
            }
            IStatus updateStatus = this.getStatusPermission(146);
            if (updateStatus != Status.OK_STATUS) {
                return updateStatus;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusPermission(int permissionType) {
            String fqn;
            IType permission;
            ITreeNode permissionNode;
            IScoutBundle permissionBundle = FormNewWizard.this.m_locationPage.getLocationBundle(permissionType, true, true);
            if (permissionBundle != null && (permissionNode = FormNewWizard.this.m_locationPage.getTreeNode(permissionType, true, true)) != null && (permission = permissionBundle.findType(fqn = String.valueOf(permissionBundle.getPackageName(".security")) + "." + permissionNode.getText())) != null && permission.exists()) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + permissionNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusForm() {
            IScoutBundle formBundle = FormNewWizard.this.m_locationPage.getLocationBundle(100, true, true);
            if (formBundle != null) {
                IScoutBundle formDataBundle = FormNewWizard.this.m_locationPage.getLocationBundle(130, true, true);
                if (formDataBundle != null && !formBundle.isOnClasspath(formDataBundle)) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(130), FormNewWizard.this.m_locationPage.getTextOfNode(100)}));
                }
                IScoutBundle formServiceBundle = FormNewWizard.this.m_locationPage.getLocationBundle(200, true, true);
                if (formServiceBundle != null && !formBundle.isOnClasspath(formServiceBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(200), FormNewWizard.this.m_locationPage.getTextOfNode(100)}));
                }
                IScoutBundle permissionCreateBundle = FormNewWizard.this.m_locationPage.getLocationBundle(140, true, true);
                if (permissionCreateBundle != null && !formBundle.isOnClasspath(permissionCreateBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(140), FormNewWizard.this.m_locationPage.getTextOfNode(100)}));
                }
                IScoutBundle permissionReadBundle = FormNewWizard.this.m_locationPage.getLocationBundle(143, true, true);
                if (permissionReadBundle != null && !formBundle.isOnClasspath(permissionReadBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(143), FormNewWizard.this.m_locationPage.getTextOfNode(100)}));
                }
                IScoutBundle permissionUpdateBundle = FormNewWizard.this.m_locationPage.getLocationBundle(146, true, true);
                if (permissionUpdateBundle != null && !formBundle.isOnClasspath(permissionUpdateBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(146), FormNewWizard.this.m_locationPage.getTextOfNode(100)}));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceImplementationBundle = FormNewWizard.this.m_locationPage.getLocationBundle(210, true, true);
            if (serviceImplementationBundle != null) {
                IScoutBundle serviceInterfaceBundle = FormNewWizard.this.m_locationPage.getLocationBundle(200, true, true);
                if (serviceInterfaceBundle != null && !serviceImplementationBundle.isOnClasspath(serviceInterfaceBundle)) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(200), FormNewWizard.this.m_locationPage.getTextOfNode(210)}));
                }
                IScoutBundle permissionCreateBundle = FormNewWizard.this.m_locationPage.getLocationBundle(140, true, true);
                if (permissionCreateBundle != null && !serviceImplementationBundle.isOnClasspath(permissionCreateBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(140), FormNewWizard.this.m_locationPage.getTextOfNode(210)}));
                }
                IScoutBundle permissionReadBundle = FormNewWizard.this.m_locationPage.getLocationBundle(143, true, true);
                if (permissionReadBundle != null && !serviceImplementationBundle.isOnClasspath(permissionReadBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(143), FormNewWizard.this.m_locationPage.getTextOfNode(210)}));
                }
                IScoutBundle permissionUpdateBundle = FormNewWizard.this.m_locationPage.getLocationBundle(146, true, true);
                if (permissionUpdateBundle != null && !serviceImplementationBundle.isOnClasspath(permissionUpdateBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(146), FormNewWizard.this.m_locationPage.getTextOfNode(210)}));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = FormNewWizard.this.m_locationPage.getLocationBundle(200, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = FormNewWizard.this.m_locationPage.getTreeNodes(230, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle == null && serviceRegistrationBundle != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "The client service registration can not be done without a service interface.");
                    }
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceInterfaceBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(200), serviceRegistrationBundle.getBundleName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = FormNewWizard.this.m_locationPage.getLocationBundle(210, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = FormNewWizard.this.m_locationPage.getTreeNodes(240, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceImplementationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(210), serviceRegistrationBundle.getBundleName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            switch (node.getType()) {
                case 100: 
                case 140: 
                case 143: 
                case 146: 
                case 200: 
                case 210: 
                case 230: 
                case 240: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            ITreeNode formDataNode;
            if (dndEvent.node.getType() == 100 && (formDataNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(130))) != null) {
                IScoutBundle[] sharedBundles;
                ITreeNode oldFomDataParent = formDataNode.getParent();
                IScoutBundle formBundle = (IScoutBundle)dndEvent.node.getParent().getData();
                IScoutBundle[] iScoutBundleArray = sharedBundles = formBundle.getRequiredBundles(ScoutBundleFilters.getSharedFilter(), false);
                int n = sharedBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    IScoutBundle formDataBundle = iScoutBundleArray[n2];
                    ITreeNode sharedNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByData(formDataBundle));
                    if (sharedNode != null) {
                        if (oldFomDataParent.equals(sharedNode)) break;
                        oldFomDataParent.removeChild(formDataNode);
                        formDataNode.setParent(sharedNode);
                        sharedNode.addChild(formDataNode);
                        break;
                    }
                    ++n2;
                }
            }
            FormNewWizard.this.m_formPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 230: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                case 240: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }

        private void validateDropMove(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 100: 
                case 230: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                case 140: 
                case 143: 
                case 146: 
                case 200: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 4;
                    break;
                }
                case 210: 
                case 240: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }
    }
}

