/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.FormStackNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.FormNewWizard;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class FormNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
    final IType abstractForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.AbstractForm");
    public static final String PROP_NLS_NAME = "nlsName";
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_CREATE_FORM_ID = "createFormId";
    public static final String PROP_FORM_ID_NAME = "formIdName";
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private Button m_createFormIdField;
    private StyledTextField m_formIdField;
    private final IScoutBundle m_clientBundle;

    public FormNewWizardPage(IScoutBundle clientBundle) {
        super(FormNewWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle(Texts.get((String)"Form"));
        this.setDescription(Texts.get((String)"CreateANewForm"));
        this.setSuperTypeInternal(this.abstractForm);
        this.setCreateFormId(true);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, this.getClientBundle().findBestMatchNlsProject(), Texts.get((String)"Name"));
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    FormNewWizardPage.this.setStateChanging(true);
                    String oldKey = "";
                    if (FormNewWizardPage.this.getNlsName() != null) {
                        oldKey = FormNewWizardPage.this.getNlsName().getKey();
                    }
                    INlsEntry newName = (INlsEntry)event.proposal;
                    FormNewWizardPage.this.setNlsNameInternal(newName);
                    if (newName != null) {
                        if (StringUtility.isNullOrEmpty((String)FormNewWizardPage.this.m_typeNameField.getModifiableText()) || oldKey.equals(FormNewWizardPage.this.m_typeNameField.getModifiableText())) {
                            FormNewWizardPage.this.m_typeNameField.setText(newName.getKey());
                        }
                        if (StringUtility.isNullOrEmpty((String)FormNewWizardPage.this.m_formIdField.getModifiableText()) || oldKey.equals(FormNewWizardPage.this.m_formIdField.getModifiableText())) {
                            FormNewWizardPage.this.m_formIdField.setText(newName.getKey());
                        }
                    }
                }
                finally {
                    FormNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Form");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormNewWizardPage.this.setTypeNameInternal(FormNewWizardPage.this.m_typeNameField.getText());
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iForm, this.getClientBundle().getJavaProject(), this.abstractForm));
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                FormNewWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        Control formIdGroup = this.createIdGroup(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        formIdGroup.setLayoutData((Object)new GridData(768));
    }

    protected Control createIdGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Texts.get((String)"FormId"));
        this.m_createFormIdField = new Button((Composite)group, 32);
        this.m_createFormIdField.setText(Texts.get((String)"CreateFormId"));
        this.m_createFormIdField.setSelection(this.isCreateFormId());
        this.m_createFormIdField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormNewWizardPage.this.setCreateFormIdInternal(FormNewWizardPage.this.m_createFormIdField.getSelection());
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_formIdField = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"PropertyNameId"));
        this.m_formIdField.setReadOnlySuffix("Nr");
        this.m_formIdField.setText(this.getTypeName());
        this.m_formIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormNewWizardPage.this.setFormIdInternal(FormNewWizardPage.this.m_formIdField.getText());
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_createFormIdField.setLayoutData((Object)new GridData(768));
        this.m_formIdField.setLayoutData(new GridData(768));
        return group;
    }

    void fillOperation(FormStackNewOperation operation) {
        IType superTypeProp;
        operation.setCreateIdProperty(this.isCreateFormId());
        operation.setFormIdName(this.getFormId());
        operation.setFormName(this.getTypeName());
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName());
        }
        if ((superTypeProp = this.getSuperType()) != null) {
            operation.setFormSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getFullyQualifiedName(), (boolean)true));
        }
    }

    public FormNewWizard getWizard() {
        return (FormNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusPropertyId());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusPropertyId() {
        if (this.isCreateFormId() && (StringUtility.isNullOrEmpty((String)this.getFormId()) || this.getFormId().equals("Nr"))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"IdNameMissing"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Form")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(".ui.forms")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public INlsEntry getNlsName() {
        return (INlsEntry)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(INlsEntry proposal) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(proposal);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(proposal);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(INlsEntry proposal) {
        this.setProperty(PROP_NLS_NAME, proposal);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public boolean isCreateFormId() {
        return this.getPropertyBool(PROP_CREATE_FORM_ID);
    }

    public void setCreateFormId(boolean createFormId) {
        try {
            this.setStateChanging(true);
            this.setCreateFormIdInternal(createFormId);
            if (this.isControlCreated()) {
                this.m_createFormIdField.setSelection(createFormId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setCreateFormIdInternal(boolean createFormId) {
        this.setPropertyBool(PROP_CREATE_FORM_ID, createFormId);
    }

    public String getFormId() {
        return this.getPropertyString(PROP_FORM_ID_NAME);
    }

    public void setFormId(String formId) {
        try {
            this.setStateChanging(true);
            this.setFormIdInternal(formId);
            if (this.isControlCreated()) {
                this.m_formIdField.setText(formId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFormIdInternal(String formId) {
        this.setPropertyString(PROP_FORM_ID_NAME, formId);
    }
}

