/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.SearchFormNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.form.SearchFormNewWizardPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class SearchFormNewWizard
extends AbstractWorkspaceWizard {
    public static final int TYPE_SEARCH_FORM = 100;
    public static final int TYPE_SEARCH_FORM_DATA = 101;
    public static final int TYPE_HANDLER_SEARCH = 102;
    private final IScoutBundle m_clientBundle;
    private SearchFormNewWizardPage m_page1;
    private BundleTreeWizardPage m_page2;
    private SearchFormNewOperation m_operation = new SearchFormNewOperation();
    private ITreeNode m_locationPageRoot;

    public SearchFormNewWizard(IScoutBundle clientBundle) {
        this.setWindowTitle(Texts.get((String)"NewSearchForm"));
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_clientBundle = clientBundle;
        this.m_page1 = new SearchFormNewWizardPage(clientBundle);
        this.m_page1.addStatusProvider(statusProvider);
        this.addPage((IWizardPage)this.m_page1);
        this.m_locationPageRoot = this.createTree(clientBundle);
        this.m_page2 = new BundleTreeWizardPage(Texts.get((String)"SearchFormClassLocations"), Texts.get((String)"OrganiseLocations"), this.m_locationPageRoot, new P_InitialCheckedFilter());
        this.m_page2.addStatusProvider(statusProvider);
        this.m_page2.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_page2);
        this.m_page1.addPropertyChangeListener(new P_LocationPropertyListener());
    }

    public void setTablePage(IType tablePage) {
        if (tablePage != null) {
            this.m_page1.setTablePageType(tablePage);
        }
    }

    public void setNlsEntry(INlsEntry nlsEntry) {
        if (nlsEntry != null) {
            this.m_page1.setNlsName(nlsEntry);
            this.m_page1.setTypeName(String.valueOf(nlsEntry.getKey()) + "SearchForm");
        } else {
            this.m_page1.setNlsName(null);
        }
    }

    private ITreeNode createTree(IScoutBundle clientBundle) {
        IScoutBundle sharedBundle = null;
        IScoutProject scoutProject = clientBundle.getScoutProject();
        while (sharedBundle == null && scoutProject != null) {
            sharedBundle = scoutProject.getSharedBundle();
            scoutProject = scoutProject.getParentProject();
        }
        ITreeNode rootNode = TreeUtility.createBundleTree(clientBundle.getScoutProject(), NodeFilters.getAcceptAll());
        ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
        ITreeNode formNode = TreeUtility.createNode(clientNode, 100, Texts.get((String)"SearchForm"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 100L);
        TreeUtility.createNode(formNode, 102, Texts.get((String)"SearchHandler"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 102L);
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, 101, Texts.get((String)"SearchFormData"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 101L);
        }
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        this.m_operation.setTypeName(this.m_page1.getTypeName());
        this.m_operation.setNlsEntry(this.m_page1.getNlsName());
        IType superTypeProp = this.m_page1.getSuperType();
        if (superTypeProp != null) {
            this.m_operation.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getFullyQualifiedName(), (boolean)true));
        }
        this.m_operation.setTablePage(this.m_page1.getTablePageType());
        this.m_operation.setCreateSearchHandler(this.m_page2.getTreeNode(102, true, true) != null);
        this.m_operation.setSearchFormLocationBundle(this.m_page2.getLocationBundle(100, true, true));
        this.m_operation.setSearchFormDataLocationBundle(this.m_page2.getLocationBundle(101, true, true));
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("exception during perfoming finish of wizard.", e);
            return false;
        }
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    private class P_InitialCheckedFilter
    implements ITreeNodeFilter {
        private P_InitialCheckedFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 100: 
                case 101: 
                case 102: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = SearchFormNewWizard.this.m_page1.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    String prefix = typeName.replaceAll("SearchForm$", "");
                    TreeUtility.findNode(SearchFormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(100)).setText(String.valueOf(prefix) + "SearchForm");
                    TreeUtility.findNode(SearchFormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(101)).setText(String.valueOf(prefix) + "SearchFormData");
                    SearchFormNewWizard.this.m_page2.refreshTree();
                }
                SearchFormNewWizard.this.m_page2.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusSearchForm(source));
            multiStatus.add(this.getStatusTypeNames(source));
        }

        protected IStatus getStatusTypeNames(Object source) {
            String fqn;
            ITreeNode formDataNode;
            String fqn2;
            ITreeNode searchFormNode;
            IScoutBundle searchFormBundle = SearchFormNewWizard.this.m_page2.getLocationBundle(100, true, true);
            if (searchFormBundle != null && (searchFormNode = SearchFormNewWizard.this.m_page2.getTreeNode(100, true, true)) != null && searchFormBundle.findType(fqn2 = String.valueOf(searchFormBundle.getPackageName(".ui.searchforms")) + "." + searchFormNode.getText()) != null) {
                return new Status(source instanceof SearchFormNewWizardPage ? 4 : 2, "org.eclipse.scout.sdk.ui", "'" + searchFormNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            IScoutBundle formDataBundle = SearchFormNewWizard.this.m_page2.getLocationBundle(101, true, true);
            if (formDataBundle != null && (formDataNode = SearchFormNewWizard.this.m_page2.getTreeNode(101, true, true)) != null && formDataBundle.findType(fqn = String.valueOf(formDataBundle.getPackageName(".services.process")) + "." + formDataNode.getText()) != null) {
                return new Status(source instanceof SearchFormNewWizardPage ? 2 : 4, "org.eclipse.scout.sdk.ui", "'" + formDataNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusSearchForm(Object source) {
            IScoutBundle formDataBundle;
            IScoutBundle formBundle = SearchFormNewWizard.this.m_page2.getLocationBundle(100, true, true);
            if (formBundle != null && (formDataBundle = SearchFormNewWizard.this.m_page2.getLocationBundle(101, true, true)) != null && !formBundle.isOnClasspath(formDataBundle)) {
                return new Status(source instanceof SearchFormNewWizardPage ? 2 : 4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{SearchFormNewWizard.this.m_page2.getTextOfNode(101), SearchFormNewWizard.this.m_page2.getTextOfNode(100)}));
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            switch (node.getType()) {
                case 100: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            ITreeNode formDataNode;
            if (dndEvent.node.getType() == 100 && (formDataNode = TreeUtility.findNode(SearchFormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(101))) != null) {
                IScoutBundle[] sharedBundles;
                ITreeNode oldFomDataParent = formDataNode.getParent();
                IScoutBundle formBundle = (IScoutBundle)dndEvent.node.getParent().getData();
                IScoutBundle[] iScoutBundleArray = sharedBundles = formBundle.getRequiredBundles(ScoutBundleFilters.getSharedFilter(), false);
                int n = sharedBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    IScoutBundle formDataBundle = iScoutBundleArray[n2];
                    ITreeNode sharedNode = TreeUtility.findNode(SearchFormNewWizard.this.m_locationPageRoot, NodeFilters.getByData(formDataBundle));
                    if (sharedNode != null) {
                        if (oldFomDataParent.equals(sharedNode)) break;
                        oldFomDataParent.removeChild(formDataNode);
                        formDataNode.setParent(sharedNode);
                        sharedNode.addChild(formDataNode);
                        break;
                    }
                    ++n2;
                }
            }
            SearchFormNewWizard.this.m_page1.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            dndEvent.doit = false;
        }

        private void validateDropMove(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 100: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }
    }
}

