/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.service.ProcessServiceNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ProcessServiceNewWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_FORM_DATA_TYPE = "formDataType";
    final IType abstractService = TypeUtility.getType((String)"org.eclipse.scout.service.AbstractService");
    final IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
    final IType abstractFormData = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.form.AbstractFormData");
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_formDataTypeField;
    private IScoutBundle m_serverBundle;

    public ProcessServiceNewWizardPage() {
        super(ProcessServiceNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewProcessService"));
        this.setDescription(Texts.get((String)"CreateANewProcessService"));
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("ProcessService");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessServiceNewWizardPage.this.setTypeNameInternal(ProcessServiceNewWizardPage.this.m_typeNameField.getText());
                ProcessServiceNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iService, this.getServerBundle().getJavaProject(), this.abstractService));
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                ProcessServiceNewWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                ProcessServiceNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_formDataTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"FormData"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                IPrimaryTypeTypeHierarchy formDataHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)ProcessServiceNewWizardPage.this.abstractFormData);
                IType[] formDataTypes = formDataHierarchy.getAllSubtypes(ProcessServiceNewWizardPage.this.abstractFormData, TypeFilters.getTypesOnClasspath((IJavaProject)ProcessServiceNewWizardPage.this.getServerBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
                return new Object[][]{formDataTypes};
            }
        });
        this.m_formDataTypeField.acceptProposal(this.getFormDataType());
        this.m_formDataTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                ProcessServiceNewWizardPage.this.setFormDataTypeInternal((IType)event.proposal);
                ProcessServiceNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        GridData formDataTypeFieldData = new GridData(768);
        this.m_formDataTypeField.setLayoutData(formDataTypeFieldData);
    }

    void fillProcessServiceNewOperation(ProcessServiceNewOperation op) {
        op.setServiceImplementationName(this.getTypeName());
        op.setServiceInterfaceName("I" + this.getTypeName());
        op.setFormData(this.getFormDataType());
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("ProcessService")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.existsType((String)(String.valueOf(this.getServerBundle().getPackageName(".services.process")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getServerBundle() {
        return this.m_serverBundle;
    }

    public void setServerBundle(IScoutBundle serverBundle) {
        this.m_serverBundle = serverBundle;
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public void setFormDataType(IType formDataType) {
        try {
            this.setStateChanging(true);
            this.setFormDataTypeInternal(formDataType);
            if (this.isControlCreated()) {
                this.m_formDataTypeField.acceptProposal(formDataType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setFormDataTypeInternal(IType formDatatype) {
        this.setProperty(PROP_FORM_DATA_TYPE, formDatatype);
    }

    public IType getFormDataType() {
        return (IType)this.getProperty(PROP_FORM_DATA_TYPE);
    }
}

