/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ServiceNewWizardPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class SqlServiceNewWizard
extends AbstractWorkspaceWizard {
    public static final int TYPE_SERVICE_IMPLEMENTATION = 108;
    public static final int TYPE_SERVICE_REG_SERVER = 110;
    private ServiceNewWizardPage m_serviceNewWizardPage;
    private BundleTreeWizardPage m_locationWizardPage;
    private ITreeNode m_locationWizardPageRoot;
    private ServiceNewOperation m_operation = new ServiceNewOperation();

    public SqlServiceNewWizard(IScoutBundle serverBundle) {
        this.setWindowTitle(Texts.get((String)"NewSQLService"));
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_locationWizardPageRoot = this.createTree(serverBundle);
        this.m_locationWizardPage = new BundleTreeWizardPage(Texts.get((String)"SQLServiceLocation"), Texts.get((String)"OrganiseLocations"), this.m_locationWizardPageRoot, new P_InitialCheckerFilter());
        this.m_locationWizardPage.addStatusProvider(statusProvider);
        this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
        this.m_serviceNewWizardPage = new ServiceNewWizardPage(Texts.get((String)"NewSQLService"), Texts.get((String)"CreateANewSQLService"), TypeUtility.getType((String)"org.eclipse.scout.rt.server.services.common.jdbc.ISqlService"), "SqlService");
        this.m_serviceNewWizardPage.setLocationBundle(serverBundle);
        this.m_serviceNewWizardPage.addStatusProvider(statusProvider);
        this.m_serviceNewWizardPage.setSuperType(TypeUtility.getType((String)"org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlService"));
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        this.addPage((IWizardPage)this.m_locationWizardPage);
        this.m_serviceNewWizardPage.setSuperType(TypeUtility.getType((String)"org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlService"));
    }

    private ITreeNode createTree(IScoutBundle serverBundle) {
        ITreeNode rootNode = TreeUtility.createBundleTree(serverBundle.getScoutProject(), NodeFilters.getByType(5));
        ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
        TreeUtility.createNode(serverNode, 108, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 108L);
        TreeUtility.createNode(serverNode, 110, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 110L);
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle[] serverRegBundles;
        IScoutBundle implementationBundle;
        IType superType = this.m_serviceNewWizardPage.getSuperType();
        if (superType != null) {
            this.m_operation.setServiceSuperTypeSignature(Signature.createTypeSignature((String)superType.getFullyQualifiedName(), (boolean)true));
        }
        if ((implementationBundle = this.m_locationWizardPage.getLocationBundle(108, true, true)) != null) {
            this.m_operation.setImplementationBundle(implementationBundle);
            this.m_operation.setServicePackageName(implementationBundle.getPackageName(".services.common.sql"));
            this.m_operation.setServiceName(this.m_locationWizardPage.getTextOfNode(108, true, true));
        }
        IScoutBundle[] iScoutBundleArray = serverRegBundles = this.m_locationWizardPage.getLocationBundles(110, true, true);
        int n = serverRegBundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle sb = iScoutBundleArray[n2];
            this.m_operation.addServiceRegistrationBundle(sb);
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    private class P_InitialCheckerFilter
    implements ITreeNodeFilter {
        private P_InitialCheckerFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 108: 
                case 110: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = SqlServiceNewWizard.this.m_serviceNewWizardPage.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    String prefix = typeName.replaceAll("SqlService$", "");
                    TreeUtility.findNode(SqlServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(108)).setText(String.valueOf(prefix) + "SqlService");
                    SqlServiceNewWizard.this.m_locationWizardPage.refreshTree();
                }
                SqlServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusServiceRegistrationServer());
            multiStatus.add(this.getStatusTypeNames());
        }

        protected IStatus getStatusTypeNames() {
            String fqn;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = SqlServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = SqlServiceNewWizard.this.m_locationWizardPage.getTreeNode(108, true, true)) != null && serviceImplementationBundle.findType(fqn = String.valueOf(serviceImplementationBundle.getPackageName(".services.common.sql")) + "." + serviceImplNode.getText()) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = SqlServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = SqlServiceNewWizard.this.m_locationWizardPage.getTreeNodes(110, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceImplementationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{SqlServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108), serviceRegistrationBundle.getBundleName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            switch (node.getType()) {
                case 108: 
                case 110: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            SqlServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }

        private void validateDropMove(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 108: 
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }
    }
}

