/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.javadoc;

import java.util.ArrayList;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class JavaDoc {
    private final IMember m_member;
    private ArrayList<String> m_newLines = new ArrayList();

    public JavaDoc(IMember member) {
        this.m_member = member;
    }

    public void appendLine(String commentLine) {
        this.m_newLines.add(commentLine);
    }

    public void removeLine(String commentLine) {
        this.m_newLines.remove(commentLine);
    }

    protected String[] getNewLines() {
        return this.m_newLines.toArray(this.m_newLines.toArray(new String[this.m_newLines.size()]));
    }

    public TextEdit getEdit() {
        String NL = ResourceUtility.getLineSeparator((IOpenable)this.getMember().getCompilationUnit());
        StringBuilder javaDoc = new StringBuilder();
        String[] newLines = this.getNewLines();
        if (newLines.length > 0) {
            String[] stringArray = newLines;
            int n = newLines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                javaDoc.append("* " + line + NL);
                ++n2;
            }
            try {
                int insertPosition = -1;
                ISourceRange javadocRange = this.getMember().getJavadocRange();
                if (javadocRange != null) {
                    String existingDoc = this.getMember().getCompilationUnit().getBuffer().getText(javadocRange.getOffset(), javadocRange.getLength());
                    insertPosition = javadocRange.getOffset() + existingDoc.lastIndexOf("*/");
                } else {
                    insertPosition = this.getMember().getSourceRange().getOffset();
                    javaDoc.insert(0, "/**" + NL);
                    javaDoc.append("*/" + NL);
                }
                if (insertPosition > 0) {
                    return new InsertEdit(insertPosition, javaDoc.toString());
                }
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logWarning("could not parse java doc of '" + this.getMember().getElementName() + "' in compilation unit '" + this.getMember().getCompilationUnit().getElementName() + "'.", e);
            }
        }
        return null;
    }

    public IMember getMember() {
        return this.m_member;
    }
}

