/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.jdt;

import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.scout.sdk.util.jdt.finegraned.FineGrainedJavaElementDelta;
import org.eclipse.scout.sdk.util.jdt.finegraned.FineGrainedJavaElementDeltaManager;

public class ElementChangedListenerEx
implements IElementChangedListener {
    public static final int CHANGED_FLAG_MASK = 7343923;

    public void elementChanged(ElementChangedEvent e) {
        CompilationUnit ast = e.getDelta().getCompilationUnitAST();
        this.visitDelta(e.getDelta(), e.getType(), ast);
    }

    private boolean visitDelta(IJavaElementDelta delta, int type, CompilationUnit ast) {
        IJavaElementDelta[] childDeltas;
        int flags = delta.getFlags();
        int kind = delta.getKind();
        IJavaElement e = delta.getElement();
        if (e != null) {
            switch (kind) {
                case 1: {
                    if (!this.visit(kind, flags, e, ast)) {
                        return false;
                    }
                    if (this.visitAdd(flags, e, ast)) break;
                    return false;
                }
                case 2: {
                    if (!this.visit(kind, flags, e, ast)) {
                        return false;
                    }
                    if (this.visitRemove(flags, e, ast)) break;
                    return false;
                }
                case 4: {
                    if (e.getElementType() == 4 && !this.visitPackageModify(flags, e, ast)) {
                        return false;
                    }
                    if ((flags & 0x700F33) == 0) break;
                    if (e.getElementType() == 5) {
                        FineGrainedJavaElementDelta[] fineGrainedJavaElementDeltaArray = FineGrainedJavaElementDeltaManager.getInstance().getDelta(delta);
                        int n = fineGrainedJavaElementDeltaArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FineGrainedJavaElementDelta a = fineGrainedJavaElementDeltaArray[n2];
                            if (!this.visit(kind, flags, a.getElement(), ast)) {
                                return false;
                            }
                            if (!this.visitModify(flags, a.getElement(), ast)) {
                                return false;
                            }
                            ++n2;
                        }
                        break;
                    }
                    if (!this.visit(kind, flags, e, ast)) {
                        return false;
                    }
                    if (this.visitModify(flags, e, ast)) break;
                    return false;
                }
            }
        }
        if ((flags & 8) != 0 && (childDeltas = delta.getAffectedChildren()) != null && childDeltas.length > 0) {
            int i = 0;
            while (i < childDeltas.length) {
                if (!this.visitDelta(childDeltas[i], type, ast)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean visit(int kind, int flags, IJavaElement e, CompilationUnit ast) {
        return true;
    }

    protected boolean visitAdd(int flags, IJavaElement e, CompilationUnit ast) {
        return true;
    }

    protected boolean visitRemove(int flags, IJavaElement e, CompilationUnit ast) {
        return true;
    }

    protected boolean visitModify(int flags, IJavaElement e, CompilationUnit ast) {
        return true;
    }

    protected boolean visitPackageModify(int flags, IJavaElement e, CompilationUnit ast) {
        return true;
    }
}

