/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.jdt.SourceRange;
import org.eclipse.scout.sdk.util.type.FieldFilters;
import org.eclipse.scout.sdk.util.type.IFieldFilter;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.scout.sdk.util.type.IPropertyBeanFilter;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.PropertyBean;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;

public class TypeUtility {
    private static final Pattern BEAN_METHOD_NAME = Pattern.compile("(get|set|is)([A-Z].*)");

    protected TypeUtility() {
    }

    public static IType getType(String fullyQualifiedName) {
        return TypeCacheAccessor.getTypeCache().getType(fullyQualifiedName);
    }

    public static IType[] getTypes(String fullyQualifiedName) {
        return TypeCacheAccessor.getTypeCache().getTypes(fullyQualifiedName);
    }

    public static boolean existsType(String fullyQualifiedName) {
        return TypeCacheAccessor.getTypeCache().existsType(fullyQualifiedName);
    }

    public static IType[] getAllCachedTypes() {
        return TypeCacheAccessor.getTypeCache().getAllCachedTypes();
    }

    public static IJavaSearchScope newSearchScope(IJavaElement element) {
        return TypeUtility.newSearchScope(new IJavaElement[]{element});
    }

    public static IJavaSearchScope newSearchScope(IJavaElement[] elements) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])elements);
    }

    public static IPackageFragment[] getSubPackages(IPackageFragment packageFragment) {
        ArrayList<IPackageFragment> subPackages = new ArrayList<IPackageFragment>();
        String prefix = String.valueOf(packageFragment.getElementName()) + ".";
        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)packageFragment.getAncestor(3);
        if (TypeUtility.exists((IJavaElement)packageFragmentRoot)) {
            try {
                IJavaElement[] iJavaElementArray = packageFragmentRoot.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement candidate = iJavaElementArray[n2];
                    if (TypeUtility.exists(candidate) && candidate.getElementType() == 4 && candidate.getElementName().startsWith(prefix)) {
                        subPackages.add((IPackageFragment)candidate);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logError("could not get subpackages of '" + packageFragment.getElementName() + "'.", e);
            }
        }
        return subPackages.toArray(new IPackageFragment[subPackages.size()]);
    }

    public static boolean isSubtype(IType type, IType potentialSubtype, org.eclipse.jdt.core.ITypeHierarchy hierarchy) {
        HashSet<IType> allSubtypes = new HashSet<IType>(Arrays.asList(hierarchy.getAllSubtypes(type)));
        return allSubtypes.contains(potentialSubtype);
    }

    public static IType[] toArray(IType ... types) {
        if (types == null) {
            return new IType[0];
        }
        return types;
    }

    public static IType[] getInnerTypes(IType type) {
        return TypeUtility.getInnerTypes(type, null);
    }

    public static IType[] getInnerTypes(IType type, ITypeFilter filter) {
        return TypeUtility.getInnerTypes(type, filter, null);
    }

    public static IType[] getInnerTypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        ArrayList<IType> unsortedTypes = new ArrayList<IType>();
        try {
            IType[] iTypeArray = type.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType subType = iTypeArray[n2];
                if (filter == null || filter.accept(subType)) {
                    unsortedTypes.add(subType);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get inner types of '" + type.getFullyQualifiedName() + "'", e);
        }
        if (comparator == null) {
            return unsortedTypes.toArray(new IType[unsortedTypes.size()]);
        }
        TreeSet<IType> sortedTypes = new TreeSet<IType>(comparator);
        sortedTypes.addAll(unsortedTypes);
        return sortedTypes.toArray(new IType[sortedTypes.size()]);
    }

    public static IType[] getInnerTypesOrdered(IType declaringType, IType superType, Comparator<IType> comparator) {
        ITypeHierarchy combinedTypeHierarchy = TypeUtility.getLocalTypeHierarchy(new IJavaElement[]{declaringType});
        IType[] allSubtypes = TypeUtility.getInnerTypes(declaringType, TypeFilters.getSubtypeFilter(superType, combinedTypeHierarchy), comparator);
        return allSubtypes;
    }

    public static IType getTypeBySignature(String signature) {
        int arrayCount = Signature.getArrayCount((String)(signature = Signature.getTypeErasure((String)signature)));
        if (arrayCount > 0) {
            signature = signature.substring(arrayCount);
        }
        String fqn = Signature.toString((String)signature);
        return TypeUtility.getType(fqn);
    }

    public static ITypeHierarchy getLocalTypeHierarchy(IJavaElement ... elements) {
        IRegion region = JavaCore.newRegion();
        if (elements != null) {
            IJavaElement[] iJavaElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement e = iJavaElementArray[n2];
                region.add(e);
                ++n2;
            }
        }
        return TypeCacheAccessor.getHierarchyCache().getLocalHierarchy(region);
    }

    public static ITypeHierarchy getLocalTypeHierarchy(IRegion region) {
        return TypeCacheAccessor.getHierarchyCache().getLocalHierarchy(region);
    }

    public static ITypeHierarchy getSuperTypeHierarchy(IType type) {
        return TypeCacheAccessor.getHierarchyCache().getSuperHierarchy(type);
    }

    public static IPrimaryTypeTypeHierarchy[] getAllCachedPrimaryTypeHierarchies() throws IllegalArgumentException {
        return TypeCacheAccessor.getHierarchyCache().getAllCachedHierarchies();
    }

    public static IPrimaryTypeTypeHierarchy getPrimaryTypeHierarchy(IType type) throws IllegalArgumentException {
        return TypeCacheAccessor.getHierarchyCache().getPrimaryTypeHierarchy(type);
    }

    public static boolean hasInnerType(IType declaringType, String typeName) {
        IType candidate = declaringType.getType(typeName);
        return candidate != null && candidate.exists();
    }

    public static ISourceRange getContentRange(IMethod method) throws JavaModelException {
        SourceRange contentRange = null;
        if (TypeUtility.exists((IJavaElement)method)) {
            ISourceRange methodRange = method.getSourceRange();
            ISourceRange nameRange = method.getNameRange();
            int contentOffset = nameRange.getOffset() - methodRange.getOffset();
            contentRange = new SourceRange(contentOffset, methodRange.getLength() - contentOffset);
            String regex = "\\A" + method.getElementName() + "[^{]*\\{(.*)\\}\\s*\\z";
            CharSequence source = method.getSource().subSequence(contentRange.getOffset(), contentRange.getOffset() + contentRange.getLength());
            Matcher matcher = Pattern.compile(regex, 40).matcher(source);
            if (matcher.find()) {
                contentRange.setOffset(methodRange.getOffset() + contentRange.getOffset() + matcher.start(1));
                contentRange.setLength(matcher.end(1) - matcher.start(1));
            } else {
                contentRange = null;
            }
        }
        return contentRange;
    }

    public static IMethod findMethodInHierarchy(IType type, IMethodFilter filter) {
        try {
            return TypeUtility.findMethodInHierarchy(type, type.newSupertypeHierarchy(null), filter);
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not create super type hierarchy of '" + type.getFullyQualifiedName() + "'.", e);
            return null;
        }
    }

    public static IMethod findMethodInHierarchy(IType type, org.eclipse.jdt.core.ITypeHierarchy hierarchy, IMethodFilter filter) {
        if (TypeUtility.exists((IJavaElement)type)) {
            IMethod method = TypeUtility.getFirstMethod(type, filter);
            if (TypeUtility.exists((IJavaElement)method)) {
                return method;
            }
            TypeUtility.findMethodInHierarchy(hierarchy.getSuperclass(type), hierarchy, filter);
        }
        return null;
    }

    public static IMethod getFirstMethod(IType type, IMethodFilter filter) {
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (filter == null || filter.accept(method)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get methods of '" + type.getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    public static IMethod getMethod(IType type, final String methodName) {
        IMethod[] methods = TypeUtility.getMethods(type, new IMethodFilter(){

            @Override
            public boolean accept(IMethod method) {
                return method.getElementName().equals(methodName);
            }
        });
        if (methods.length > 0) {
            return methods[0];
        }
        return null;
    }

    public static IMethod[] getMethods(IType type) {
        return TypeUtility.getMethods(type, null);
    }

    public static IMethod[] getMethods(IType type, IMethodFilter filter) {
        return TypeUtility.getMethods(type, filter, null);
    }

    public static IMethod[] getMethods(IType type, IMethodFilter filter, Comparator<IMethod> comparator) {
        ArrayList<IMethod> unsortedMethods = new ArrayList<IMethod>();
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (filter == null || filter.accept(method)) {
                    unsortedMethods.add(method);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get methods of '" + type.getFullyQualifiedName() + "'.", e);
        }
        if (comparator == null) {
            return unsortedMethods.toArray(new IMethod[unsortedMethods.size()]);
        }
        TreeSet<IMethod> sortedMethods = new TreeSet<IMethod>(comparator);
        sortedMethods.addAll(unsortedMethods);
        return sortedMethods.toArray(new IMethod[sortedMethods.size()]);
    }

    public static IType getAncestor(IType type, ITypeFilter filter) {
        IType ancestorType = type;
        while (TypeUtility.exists((IJavaElement)ancestorType)) {
            if (filter.accept(ancestorType)) {
                return ancestorType;
            }
            ancestorType = ancestorType.getDeclaringType();
        }
        return null;
    }

    public static IField[] getFields(IType declaringType) {
        return TypeUtility.getFields(declaringType, null);
    }

    public static IField[] getFields(IType declaringType, IFieldFilter filter) {
        return TypeUtility.getFields(declaringType, filter, null);
    }

    public static IField[] getFields(IType declaringType, IFieldFilter filter, Comparator<IField> comparator) {
        ArrayList<IField> unsortedFields = new ArrayList<IField>();
        try {
            IField[] iFieldArray = declaringType.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField candidate = iFieldArray[n2];
                if (filter == null || filter.accept(candidate)) {
                    unsortedFields.add(candidate);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get fields of '" + declaringType.getElementName() + "'.", e);
        }
        if (comparator == null) {
            return unsortedFields.toArray(new IField[unsortedFields.size()]);
        }
        TreeSet<IField> sortedFields = new TreeSet<IField>(comparator);
        sortedFields.addAll(unsortedFields);
        return sortedFields.toArray(new IField[sortedFields.size()]);
    }

    public static IField getFirstField(IType type, IFieldFilter filter) {
        try {
            IField[] iFieldArray = type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField method = iFieldArray[n2];
                if (filter == null || filter.accept(method)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get methods of '" + type.getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    public static boolean equalTypes(IType[] arr1, IType[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null) {
            return false;
        }
        if (arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        Arrays.sort(arr1, TypeComparators.getHashCodeComparator());
        Arrays.sort(arr2, TypeComparators.getHashCodeComparator());
        return Arrays.equals(arr1, arr2);
    }

    public static IMethod getOverwrittenMethod(IMethod method, org.eclipse.jdt.core.ITypeHierarchy superTypeHierarchy) {
        IType superType = superTypeHierarchy.getSuperclass(method.getDeclaringType());
        IMethodFilter overrideFilter = MethodFilters.getSuperMethodFilter(method);
        while (superType != null) {
            IMethod superMethod = TypeUtility.getFirstMethod(superType, overrideFilter);
            if (superMethod != null) {
                return superMethod;
            }
            superType = superTypeHierarchy.getSuperclass(superType);
        }
        return null;
    }

    public static IType getToplevelType(IType type) {
        if (type == null) {
            return null;
        }
        if (type.getParent().getElementType() != 7) {
            return type;
        }
        return TypeUtility.getToplevelType(type.getDeclaringType());
    }

    public static IType[] getTypesInPackage(IPackageFragment pck) {
        return TypeUtility.getTypesInPackage(pck, null);
    }

    public static IType[] getTypesInPackage(IPackageFragment pck, ITypeFilter filter) {
        return TypeUtility.getTypesInPackage(pck, filter, null);
    }

    public static IType[] getTypesInPackage(IPackageFragment pck, ITypeFilter filter, Comparator<IType> comparator) {
        return TypeUtility.getTypesInPackage(pck, filter, comparator, false);
    }

    public static IType[] getTypesInPackage(IPackageFragment pck, ITypeFilter filter, Comparator<IType> comparator, boolean includeSubpackages) {
        ArrayList<IType> unsortedTypes = new ArrayList<IType>();
        TypeUtility.collectTypesInPackage(pck, filter, includeSubpackages, unsortedTypes);
        if (comparator == null) {
            return unsortedTypes.toArray(new IType[unsortedTypes.size()]);
        }
        TreeSet<IType> sortedTypes = new TreeSet<IType>(comparator);
        sortedTypes.addAll(unsortedTypes);
        return sortedTypes.toArray(new IType[sortedTypes.size()]);
    }

    private static void collectTypesInPackage(IPackageFragment pck, ITypeFilter filter, boolean includeSubPackages, Collection<IType> collector) {
        try {
            if (pck != null && pck.exists()) {
                IJavaElement[] iJavaElementArray = pck.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit icu;
                    IType[] types;
                    IJavaElement element = iJavaElementArray[n2];
                    if (element.getElementType() == 4) {
                        if (includeSubPackages) {
                            TypeUtility.collectTypesInPackage((IPackageFragment)element, filter, includeSubPackages, collector);
                        }
                    } else if (element.getElementType() == 5 && (types = (icu = (ICompilationUnit)element).getTypes()) != null && types.length > 0) {
                        collector.add(types[0]);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get types of package '" + pck.getElementName() + "'", e);
        }
    }

    public static boolean exists(IJavaElement element) {
        return element != null && element.exists();
    }

    public static IType findInnerType(IType type, String innerTypeName) {
        if (type == null) {
            return null;
        }
        if (StringUtility.equalsIgnoreCase((String)type.getElementName(), (String)innerTypeName)) {
            return type;
        }
        try {
            IType[] iTypeArray = type.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType innerType = iTypeArray[n2];
                IType found = TypeUtility.findInnerType(innerType, innerTypeName);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logError("could not find inner type named '" + innerTypeName + "' in type '" + type.getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    public static IType getReferencedType(IType declaringType, String typeName) throws JavaModelException {
        String[][] resolvedTypeName;
        ICompilationUnit compilationUnit = declaringType.getCompilationUnit();
        if (compilationUnit != null) {
            IImportDeclaration[] imports;
            IImportDeclaration[] iImportDeclarationArray = imports = compilationUnit.getImports();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IType foundType;
                IImportDeclaration imp = iImportDeclarationArray[n2];
                if (imp.getElementName().endsWith("." + typeName) && (foundType = TypeUtility.getType(imp.getElementName())) != null) {
                    return foundType;
                }
                ++n2;
            }
        }
        if ((resolvedTypeName = declaringType.resolveType(typeName)) != null && resolvedTypeName.length == 1) {
            IType foundType;
            String fqName = resolvedTypeName[0][0];
            if (fqName != null && fqName.length() > 0) {
                fqName = String.valueOf(fqName) + ".";
            }
            if ((foundType = TypeUtility.getType(fqName = String.valueOf(fqName) + resolvedTypeName[0][1])) != null) {
                return foundType;
            }
        }
        SdkUtilActivator.logWarning("could not find referenced type '" + typeName + "' in '" + declaringType.getFullyQualifiedName() + "'.");
        return null;
    }

    public static boolean isGenericType(IType type) {
        try {
            return TypeUtility.exists((IJavaElement)type) && type.getTypeParameters().length > 0;
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get generic information of type: " + type.getFullyQualifiedName(), e);
            return false;
        }
    }

    public static boolean isOnClasspath(IMember member, IJavaProject project) {
        if (member == null) {
            return false;
        }
        if (member.isBinary()) {
            return project.isOnClasspath((IJavaElement)member);
        }
        if (member.getJavaProject() != null) {
            if (member.getJavaProject().equals(project)) {
                return true;
            }
            return project.isOnClasspath((IJavaElement)member.getJavaProject());
        }
        return false;
    }

    public static IPropertyBean[] getPropertyBeans(IType type, IPropertyBeanFilter propertyFilter, Comparator<IPropertyBean> comparator) {
        IField[] name;
        IMethod[] methods;
        HashMap<IField[], PropertyBean> beans = new HashMap<IField[], PropertyBean>();
        IMethodFilter filter = MethodFilters.getMultiMethodFilter(MethodFilters.getFlagsFilter(1), MethodFilters.getNameRegexFilter(BEAN_METHOD_NAME));
        IMethod[] iMethodArray = methods = TypeUtility.getMethods(type, filter);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            Matcher matcher = BEAN_METHOD_NAME.matcher(m.getElementName());
            if (matcher.matches()) {
                try {
                    PropertyBean desc;
                    String kind = matcher.group(1);
                    name = matcher.group(2);
                    String[] parameterTypes = m.getParameterTypes();
                    String returnType = m.getReturnType();
                    if (kind.equals("get") && parameterTypes.length == 0 && !returnType.equals("V")) {
                        desc = (PropertyBean)beans.get(name);
                        if (desc == null) {
                            desc = new PropertyBean(type, (String)name);
                            beans.put(name, desc);
                        }
                        if (desc.getReadMethod() == null) {
                            desc.setReadMethod(m);
                        }
                    } else if (kind.equals("is") && parameterTypes.length == 0 && returnType.equals("Z")) {
                        desc = (PropertyBean)beans.get(name);
                        if (desc == null) {
                            desc = new PropertyBean(type, (String)name);
                            beans.put(name, desc);
                        }
                        if (desc.getReadMethod() == null) {
                            desc.setReadMethod(m);
                        }
                    } else if (kind.equals("set") && parameterTypes.length == 1 && returnType.equals("V")) {
                        desc = (PropertyBean)beans.get(name);
                        if (desc == null) {
                            desc = new PropertyBean(type, (String)name);
                            beans.put(name, desc);
                        }
                        if (desc.getWriteMethod() == null) {
                            desc.setWriteMethod(m);
                        }
                    }
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logError("Error while collectiong property beans of type [" + type + "]", e);
                }
            }
            ++n2;
        }
        if (propertyFilter == null) {
            propertyFilter = new IPropertyBeanFilter(){

                @Override
                public boolean accept(IPropertyBean property) {
                    return true;
                }
            };
        }
        ArrayList<PropertyBean> filteredBeans = new ArrayList<PropertyBean>();
        for (PropertyBean bean : beans.values()) {
            if (!propertyFilter.accept(bean)) continue;
            filteredBeans.add(bean);
        }
        IField[] fieldCandidates = TypeUtility.getFields(type, FieldFilters.getPrivateNotStaticNotFinalNotAbstract(), null);
        HashMap<String, IField> fields = new HashMap<String, IField>();
        name = fieldCandidates;
        int e = fieldCandidates.length;
        int matcher = 0;
        while (matcher < e) {
            IField field = name[matcher];
            fields.put(field.getElementName(), field);
            ++matcher;
        }
        AssistOptions assistOptions = new AssistOptions(type.getJavaProject().getOptions(true));
        String[] fieldPrefixes = TypeUtility.toStringArray(assistOptions.fieldPrefixes, "m_", "");
        String[] fieldSuffixes = TypeUtility.toStringArray(assistOptions.fieldSuffixes, "");
        for (PropertyBean bean : filteredBeans) {
            IField field = TypeUtility.findFieldForPropertyBean(bean.getBeanName(), fields, fieldPrefixes, fieldSuffixes);
            if (field != null) {
                bean.setField(field);
                continue;
            }
            SdkUtilActivator.logWarning("Unable to find field for property bean [" + bean + "]");
        }
        if (comparator != null) {
            Collections.sort(filteredBeans, comparator);
        }
        return filteredBeans.toArray(new IPropertyBean[filteredBeans.size()]);
    }

    public static boolean isAncestor(IJavaElement parent, IJavaElement chlid) {
        if (parent == null || chlid == null) {
            return false;
        }
        if (parent.equals(chlid)) {
            return true;
        }
        if (chlid.getParent() != null && chlid.getParent().getElementType() >= parent.getElementType()) {
            return TypeUtility.isAncestor(parent, chlid.getParent().getAncestor(parent.getElementType()));
        }
        return false;
    }

    private static IField findFieldForPropertyBean(String beanName, HashMap<String, IField> fields, String[] fieldPrefixes, String[] fieldSuffixes) {
        String[] stringArray = fieldPrefixes;
        int n = fieldPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String[] stringArray2 = fieldSuffixes;
            int n3 = fieldSuffixes.length;
            int n4 = 0;
            while (n4 < n3) {
                String suffix = stringArray2[n4];
                IField field = fields.get(String.valueOf(prefix) + TypeUtility.decapitalize(beanName) + suffix);
                if (field != null) {
                    return field;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private static String[] toStringArray(char[][] arrayOfChars, String ... additionalValues) {
        int n;
        int n2;
        Object object;
        HashSet<String> result = new HashSet<String>();
        if (additionalValues != null) {
            object = additionalValues;
            n2 = additionalValues.length;
            n = 0;
            while (n < n2) {
                String s = object[n];
                result.add(s);
                ++n;
            }
        }
        if (arrayOfChars != null) {
            object = arrayOfChars;
            n2 = arrayOfChars.length;
            n = 0;
            while (n < n2) {
                String cs = object[n];
                if (cs != null && ((String)cs).length > 0) {
                    result.add(String.valueOf((char[])cs));
                }
                ++n;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private static String decapitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (s.length() >= 2 && Character.isUpperCase(s.charAt(0)) && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return String.valueOf(Character.toLowerCase(s.charAt(0))) + s.substring(1);
    }
}

