/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.dialog;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ErrorDialog
extends Dialog {
    private static final String DEFAULT_ERROR_MESSAGE = "An unexpected error occured";
    private String m_title;
    private String m_message;
    private String m_stackTrace;
    private int m_severity;

    public ErrorDialog(String title) {
        super(ScoutSdkUi.getDisplay().getActiveShell());
        this.m_title = title;
        this.setShellStyle(112);
    }

    protected final void configureShell(Shell shell) {
        Rectangle clientArea = shell.getDisplay().getClientArea();
        int width = NumberUtility.nvl((Integer)700, (Number)shell.getBounds().width);
        int height = NumberUtility.nvl((Integer)500, (Number)shell.getBounds().height);
        shell.setLocation((clientArea.width - width) / 2, (clientArea.height - height) / 2);
        shell.setSize(width, height);
        super.configureShell(shell);
        shell.setBackground(shell.getDisplay().getSystemColor(1));
        shell.setText(this.m_title);
        shell.setLayout((Layout)new FillLayout());
    }

    protected final Control createContents(Composite parent) {
        Composite container = new Composite(parent, 2);
        Composite content = new Composite(container, 2);
        Label iconLabel = new Label(content, 0);
        iconLabel.setImage(this.getImageStatus(this.m_severity));
        Label messageLabel = new Label(content, 0);
        messageLabel.setText(this.m_message);
        messageLabel.setFont(this.getFont("org.eclipse.jface.dialogfont", true));
        Text stackTraceText = new Text(content, 2882);
        stackTraceText.setEditable(false);
        stackTraceText.setText(this.m_stackTrace);
        stackTraceText.setBackground(content.getDisplay().getSystemColor(1));
        Button button = new Button(container, 0x800008);
        button.setText("OK");
        button.addSelectionListener((SelectionListener)new CloseSelectionListener());
        this.getShell().setDefaultButton(button);
        container.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(1808));
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000000;
        gridData.widthHint = button.getBounds().width + 75;
        button.setLayoutData((Object)gridData);
        content.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(0, 30);
        iconLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)iconLabel, 10, 131072);
        data.right = new FormAttachment(100, -10);
        messageLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)messageLabel, 10, 1024);
        data.left = new FormAttachment((Control)messageLabel, 0, 16384);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100, 0);
        stackTraceText.setLayoutData((Object)data);
        return container;
    }

    public void setError(String error, int severity) {
        this.m_severity = severity;
        this.m_message = error;
        this.m_stackTrace = "";
    }

    public void setError(Throwable e) {
        this.m_severity = 4;
        this.m_message = DEFAULT_ERROR_MESSAGE;
        this.m_stackTrace = this.getStackTrace(e);
    }

    public void setError(String message, Throwable e) {
        this.m_severity = 4;
        this.m_message = StringUtility.nvl((Object)message, (String)DEFAULT_ERROR_MESSAGE);
        this.m_stackTrace = this.getStackTrace(e);
    }

    private Font getFont(String symbolicName, boolean bold) {
        if (bold) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold(symbolicName);
        }
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(symbolicName);
    }

    private Image getImageStatus(int s) {
        Image image = null;
        switch (s) {
            case 4: {
                image = ScoutSdkUi.getImage((String)"error.gif");
                break;
            }
            case 2: {
                image = ScoutSdkUi.getImage((String)"warning.gif");
                break;
            }
            case 1: {
                image = ScoutSdkUi.getImage((String)"info.gif");
            }
        }
        return image;
    }

    private String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private class CloseSelectionListener
    extends SelectionAdapter {
        private CloseSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ErrorDialog.this.setReturnCode(0);
            ErrorDialog.this.close();
        }
    }
}

