/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.dialog;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.tooltip.JavadocTooltip;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.TypePresenter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TypeBrowseDialog
extends TitleAreaDialog {
    protected static final String IStructuredSelection = null;
    private IType m_type;
    private StyledTextField m_typeField;
    private Button m_typeBrowseButton;
    private JavadocTooltip m_tooltipType;
    private String m_dialogTitle;
    private String m_dialogMessage;
    private TypePresenter.ISearchJavaSearchScopeFactory m_javaSearchScopeFactory;
    private int m_typeStyle;

    public TypeBrowseDialog(Shell shell, String dialogTitle, String dialogMessage) {
        super(shell);
        this.m_dialogTitle = dialogTitle;
        this.m_dialogMessage = dialogMessage;
        this.m_typeStyle = 6;
        TypeBrowseDialog.setDialogHelpAvailable((boolean)false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected final void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.m_dialogTitle);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(this.m_dialogTitle);
        this.setMessage(this.m_dialogMessage, 1);
        this.getOkButton().setEnabled(false);
        return control;
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.m_typeField = new StyledTextField(composite, Texts.get("Type"));
        if (TypeUtility.exists((IJavaElement)this.getType())) {
            this.m_typeField.setText(this.getType().getElementName());
        }
        this.m_typeField.setEditable(false);
        this.m_typeField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TypeBrowseDialog.this.openTypeDialog();
            }
        });
        this.m_tooltipType = new JavadocTooltip((Control)this.m_typeField.getTextComponent());
        this.updateJavaDoc(this.m_tooltipType, this.getType());
        this.m_typeBrowseButton = new Button(composite, 0x800008);
        this.m_typeBrowseButton.setText(Texts.get("Browse"));
        this.m_typeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeBrowseDialog.this.openTypeDialog();
            }
        });
        parent.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(20, 0);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_typeField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_typeField, -2, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_typeBrowseButton.setLayoutData((Object)formData);
        return composite;
    }

    protected boolean getConfiguredIsDescriptionColumnVisible() {
        return false;
    }

    protected String getConfiguredNameColumnText() {
        return Texts.get("Name");
    }

    protected String getConfiguredDescriptionColumnText() {
        return Texts.get("Description");
    }

    public IType getType() {
        return this.m_type;
    }

    public void setType(IType type) {
        this.m_type = type;
    }

    public int getTypeStyle() {
        return this.m_typeStyle;
    }

    public void setTypeStyle(int typeStyle) {
        this.m_typeStyle = typeStyle;
    }

    public TypePresenter.ISearchJavaSearchScopeFactory getJavaSearchScopeFactory() {
        return this.m_javaSearchScopeFactory;
    }

    public void setJavaSearchScopeFactory(TypePresenter.ISearchJavaSearchScopeFactory javaSearchScopeFactory) {
        this.m_javaSearchScopeFactory = javaSearchScopeFactory;
    }

    private void updateJavaDoc(JavadocTooltip javadocTooltip, IType type) {
        try {
            javadocTooltip.setMember(null);
            if (TypeUtility.exists((IJavaElement)type)) {
                javadocTooltip.setMember((IMember)type);
            }
        }
        catch (Exception e) {
            JaxWsSdk.logWarning("Could not render tooltip", e);
        }
    }

    private void openTypeDialog() {
        try {
            IJavaSearchScope searchScope = this.m_javaSearchScopeFactory == null ? SearchEngine.createWorkspaceScope() : this.m_javaSearchScopeFactory.create();
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ScoutSdkUi.getShell(), null, (IJavaSearchScope)searchScope, (int)this.m_typeStyle, (boolean)false, (String)"*.*");
            dialog.setTitle(Texts.get("Type"));
            dialog.setMessage(Texts.get("ChooseXY", Texts.get("Type")));
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0 && dialog.getResult() != null) {
                IType type = (IType)dialog.getResult()[0];
                if (TypeUtility.exists((IJavaElement)type)) {
                    this.m_typeField.setText(type.getFullyQualifiedName());
                    this.updateJavaDoc(this.m_tooltipType, type);
                    this.getOkButton().setEnabled(true);
                } else {
                    this.updateJavaDoc(this.m_tooltipType, null);
                    this.m_typeField.setText("");
                    this.getOkButton().setEnabled(false);
                }
                this.setType(type);
            }
        }
        catch (JavaModelException exception) {
            JaxWsSdk.logError(exception);
        }
    }
}

