/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsProviderDeleteOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ResourceSelectionWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.IFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.ISchemaArtefactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaArtefactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;

public class WsProviderDeleteWizard
extends AbstractWorkspaceWizard {
    private ResourceSelectionWizardPage m_wizardPage;
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private BuildJaxWsBean m_buildJaxWsBean;
    private WsProviderDeleteOperation m_operation;

    public WsProviderDeleteWizard() {
        this.setWindowTitle(Texts.get("DeleteWebServiceProvider"));
    }

    public void addPages() {
        this.m_wizardPage = new ResourceSelectionWizardPage(Texts.get("DeleteWebServiceProvider"), Texts.get("QuestionDeletion"));
        this.m_wizardPage.setElements(this.getElementsToBeDeleted());
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    private List<ElementBean> getElementsToBeDeleted() {
        IFile stubJarFile;
        final LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        elements.add(new ElementBean(1, "Registration entry in sun-jaxws.xml and build-jaxws.xml", JaxWsSdk.getImageDescriptor("sunJaxWs.png"), true));
        String fqn = this.m_sunJaxWsBean.getImplementation();
        if (TypeUtility.existsType((String)fqn)) {
            IType portType = TypeUtility.getType((String)fqn);
            elements.add(new ElementBean(4, "Port type '" + portType.getFullyQualifiedName() + "'", ScoutSdkUi.getImageDescriptor((String)"class_obj.gif"), (IJavaElement)portType, false));
        }
        if ((stubJarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_buildJaxWsBean, this.m_sunJaxWsBean.getWsdl())) != null && stubJarFile.exists()) {
            elements.add(new ElementBean(2, "Stub JAR file '" + stubJarFile.getFullPath().toString() + "'", JaxWsSdk.getImageDescriptor("jar_obj.gif"), (IResource)stubJarFile, false));
        }
        IFile wsdlFile = null;
        if (StringUtility.hasText((String)this.m_sunJaxWsBean.getWsdl())) {
            wsdlFile = JaxWsSdkUtility.getFile(this.m_bundle, (IPath)new Path(this.m_sunJaxWsBean.getWsdl()), false);
        }
        if (wsdlFile != null && wsdlFile.exists()) {
            elements.add(new ElementBean(16, "WSDL file '" + wsdlFile.getProjectRelativePath().toString() + "'", JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"), (IResource)wsdlFile, false));
        }
        SchemaUtility.visitArtefacts(wsdlFile, (ISchemaArtefactVisitor<IFile>)new SchemaArtefactVisitor<IFile>(){

            @Override
            public void onReferencedWsdlArtefact(SchemaUtility.WsdlArtefact<IFile> wsdlArtefact) {
                IFileHandle fileHandle = wsdlArtefact.getFileHandle();
                if (fileHandle != null && fileHandle.exists()) {
                    elements.add(new ElementBean(32, String.format("Referenced WSDL file '%s'", fileHandle.getFullPath().toString()), JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"), (IResource)fileHandle.getFile(), false));
                }
            }

            @Override
            public void onSchemaIncludeArtefact(SchemaUtility.SchemaIncludeArtefact<IFile> schemaIncludeArtefact) {
                IFileHandle fileHandle = schemaIncludeArtefact.getFileHandle();
                if (fileHandle != null && fileHandle.exists()) {
                    elements.add(new ElementBean(64, String.format("Included XSD schema '%s'", fileHandle.getFullPath().toString()), JaxWsSdk.getImageDescriptor("xsdFile.gif"), (IResource)fileHandle.getFile(), false));
                }
            }

            @Override
            public void onSchemaImportArtefact(SchemaUtility.SchemaImportArtefact<IFile> schemaImportArtefact) {
                IFileHandle fileHandle = schemaImportArtefact.getFileHandle();
                if (fileHandle != null && fileHandle.exists()) {
                    elements.add(new ElementBean(64, String.format("Imported XSD schema '%s'", fileHandle.getFullPath().toString()), JaxWsSdk.getImageDescriptor("xsdFile.gif"), (IResource)fileHandle.getFile(), false));
                }
            }
        });
        if (this.m_buildJaxWsBean != null) {
            IFile[] bindingFiles;
            IFile[] iFileArray = bindingFiles = JaxWsSdkUtility.getBindingFiles(this.m_bundle, this.m_buildJaxWsBean.getPropertiers());
            int n = bindingFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile bindingFile = iFileArray[n2];
                if (bindingFile != null && bindingFile.exists()) {
                    elements.add(new ElementBean(8, String.format("Binding file '%s'", bindingFile.getProjectRelativePath().toString()), JaxWsSdk.getImageDescriptor("XSDTypeDefinition.gif"), (IResource)bindingFile, false));
                }
                ++n2;
            }
        }
        return elements;
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_operation = new WsProviderDeleteOperation();
        this.m_operation.setBundle(this.m_bundle);
        this.m_operation.setSunJaxWsBean(this.m_sunJaxWsBean);
        this.m_operation.setBuildJaxWsBean(this.m_buildJaxWsBean);
        LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        for (ElementBean element : this.m_wizardPage.getElements()) {
            if (!element.isChecked() && !element.isMandatory()) continue;
            elements.add(element);
        }
        this.m_operation.setElements(elements);
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        OperationJob job = new OperationJob(new IOperation[]{this.m_operation});
        job.schedule();
        return true;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public void setBuildJaxWsBean(BuildJaxWsBean buildJaxWsBean) {
        this.m_buildJaxWsBean = buildJaxWsBean;
    }
}

