/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.svg.ui.swt.svgfield;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.net.URI;
import java.net.URL;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.svg.client.SilentSVGUserAgentAdapter;
import org.eclipse.scout.svg.client.svgfield.ISvgField;
import org.eclipse.scout.svg.ui.swt.svgfield.ISwtScoutSvgField;
import org.eclipse.scout.svg.ui.swt.svgfield.JSVGCanvasSwtWrapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGPoint;

public class SwtScoutSvgField
extends SwtScoutFieldComposite<ISvgField>
implements ISwtScoutSvgField {
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        if (((ISvgField)this.getScoutObject()).isLabelVisible()) {
            int labelStyle = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
            StatusLabelEx label = new StatusLabelEx(container, labelStyle, this.getEnvironment());
            this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)label, false, false);
            this.setSwtLabel((ILabelComposite)label);
        }
        P_SVGUserAgent ua = new P_SVGUserAgent();
        JSVGCanvasSwtWrapper canvas = new JSVGCanvasSwtWrapper(container, 0, (SVGUserAgent)ua, true, false);
        canvas.getJSVGCanvas().setDocumentState(3);
        canvas.getJSVGCanvas().addMouseListener((MouseListener)new P_SwingMouseListener());
        this.getEnvironment().getFormToolkit().adapt((Control)canvas, false, false);
        this.setSwtField((Control)canvas);
        this.setSwtContainer(container);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    @Override
    public JSVGCanvasSwtWrapper getSwtField() {
        return (JSVGCanvasSwtWrapper)super.getSwtField();
    }

    protected void attachScout() {
        super.attachScout();
        this.updateSvgDocumentFromScout();
    }

    protected void detachScout() {
        super.detachScout();
        this.getSwtField().getJSVGCanvas().stopProcessing();
        this.getSwtField().getJSVGCanvas().dispose();
    }

    protected void updateSvgDocumentFromScout() {
        SVGDocument doc = ((ISvgField)this.getScoutObject()).getSvgDocument();
        JSVGCanvas canvas = this.getSwtField().getJSVGCanvas();
        canvas.setSVGDocument(doc);
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("svgDocument")) {
            this.updateSvgDocumentFromScout();
        }
    }

    protected void handleSwingClick(MouseEvent e) {
        try {
            JSVGCanvas canvas = this.getSwtField().getJSVGCanvas();
            AffineTransform vbTransform = canvas.getViewBoxTransform().createInverse();
            Point2D p = new Point2D.Double(e.getX(), e.getY());
            p = vbTransform.transform(p, null);
            final SVGOMPoint svgPoint = new SVGOMPoint((float)p.getX(), (float)p.getY());
            new ClientSyncJob("Click", this.getEnvironment().getClientSession()){

                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    ((ISvgField)SwtScoutSvgField.this.getScoutObject()).getUIFacade().fireClickFromUI((SVGPoint)svgPoint);
                }
            }.schedule();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
    }

    private class P_SVGUserAgent
    extends SilentSVGUserAgentAdapter {
        private P_SVGUserAgent() {
        }

        public void openLink(String uri, boolean newc) {
            try {
                final URL url = new URI(uri).toURL();
                new ClientSyncJob("Hyperlink", SwtScoutSvgField.this.getEnvironment().getClientSession()){

                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        ((ISvgField)SwtScoutSvgField.this.getScoutObject()).getUIFacade().fireHyperlinkFromUI(url);
                    }
                }.schedule();
            }
            catch (Throwable throwable) {}
        }
    }

    private class P_SwingMouseListener
    extends MouseAdapter {
        private P_SwingMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 1) {
                SwtScoutSvgField.this.handleSwingClick(e);
            }
        }
    }
}

