/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.nature;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;

public class ScaNature
implements IProjectNature {
    private IProject project;

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.stp.sca.common.scaBuilder");
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, null);
        if (this.project.hasNature("org.eclipse.jdt.core.javanature")) {
            File scaAnnPath = ResourceUtils.getPluginBinaryPath("org.eclipse.stp.sca.osoa", null);
            if (scaAnnPath == null) {
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            Path path = new Path(scaAnnPath.getAbsolutePath());
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, null, null);
            if (Arrays.asList(entries).contains(entry)) {
                return;
            }
            int length = entries == null ? 0 : entries.length;
            IClasspathEntry[] newEntries = new IClasspathEntry[length + 1];
            System.arraycopy(entries, 0, newEntries, 0, length);
            newEntries[length] = entry;
            try {
                if (!javaProject.hasClasspathCycle(newEntries)) {
                    javaProject.setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                ScaCoreCommonPlugin.log(e, 4);
            }
        }
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.stp.sca.common.scaBuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                return;
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

