/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.wizards;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.soa.sca.core.common.Messages;
import org.eclipse.soa.sca.core.common.internal.ScaExtensionManager;
import org.eclipse.soa.sca.core.common.internal.provisional.extensions.IScaSpecificationExtension;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;
import org.eclipse.soa.sca.core.common.utils.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ScaCompsiteWizardPage
extends WizardPage {
    public static final String COMPOSITE_EXT = ".composite";
    public static final String COMPOSITE_DIAG_EXT = ".composite_diagram";
    private final IStructuredSelection selection;
    private IScaSpecificationExtension selectedExtension;
    private boolean createDiagram = true;
    private String compositeName;
    private String compositeTns = "http://eclipse.org/sca/";
    private IContainer compositeContainer;

    protected ScaCompsiteWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.setTitle(Messages.ScaCompsiteWizardPage_3);
        this.setDescription(Messages.ScaCompsiteWizardPage_4);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(Messages.ScaCompsiteWizardPage_5);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        int style = 100356;
        TreeViewer fileViewer = new TreeViewer(container, style);
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        fileViewer.getTree().setLayoutData((Object)layoutData);
        fileViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        fileViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                Object[] result = new Object[]{};
                if (parentElement instanceof IContainer) {
                    List<IContainer> children = ResourceUtils.getContainerChildren((IContainer)parentElement);
                    result = new Object[children.size()];
                    result = children.toArray(result);
                }
                return result;
            }

            public Object getParent(Object element) {
                IContainer result = null;
                if (element instanceof IResource) {
                    result = ((IResource)element).getParent();
                }
                return result;
            }

            public boolean hasChildren(Object element) {
                boolean result = false;
                if (element instanceof IContainer) {
                    result = ResourceUtils.getContainerChildren((IContainer)element).size() > 0;
                }
                return result;
            }

            public Object[] getElements(Object inputElement) {
                List<IContainer> roots = ResourceUtils.getContainerChildren((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                Object[] result = new Object[roots.size()];
                return roots.toArray(result);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        fileViewer.setInput(new Object());
        if (this.selection != null && !this.selection.isEmpty()) {
            Object o = this.selection.getFirstElement();
            if (o instanceof IContainer) {
                this.compositeContainer = (IContainer)o;
            } else if (o instanceof IResource) {
                this.compositeContainer = ((IResource)o).getParent();
            } else {
                if (o instanceof IAdaptable) {
                    o = ((IAdaptable)o).getAdapter(IResource.class);
                }
                if (o == null) {
                    o = Platform.getAdapterManager().getAdapter(o, IResource.class);
                }
                if (o instanceof IContainer) {
                    this.compositeContainer = (IContainer)o;
                } else if (o instanceof IResource) {
                    this.compositeContainer = ((IResource)o).getParent();
                }
            }
            if (this.compositeContainer != null) {
                fileViewer.setSelection((ISelection)new StructuredSelection((Object)this.compositeContainer));
                fileViewer.expandToLevel((Object)this.compositeContainer, 1);
            }
        }
        fileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                if (!s.isEmpty()) {
                    ScaCompsiteWizardPage.this.compositeContainer = (IContainer)s.getFirstElement();
                    ScaCompsiteWizardPage.this.validate();
                }
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.ScaCompsiteWizardPage_6);
        label.setToolTipText(Messages.ScaCompsiteWizardPage_7);
        final Text nameText = new Text(container, 2052);
        nameText.setLayoutData((Object)new GridData(768));
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScaCompsiteWizardPage.this.compositeName = nameText.getText();
                ScaCompsiteWizardPage.this.validate();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.ScaCompsiteWizardPage_8);
        label.setToolTipText(Messages.ScaCompsiteWizardPage_9);
        final Text tnsText = new Text(container, 2052);
        tnsText.setLayoutData((Object)new GridData(768));
        tnsText.setText(this.compositeTns);
        tnsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScaCompsiteWizardPage.this.compositeTns = tnsText.getText();
                ScaCompsiteWizardPage.this.validate();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.ScaCompsiteWizardPage_10);
        label.setToolTipText(Messages.ScaCompsiteWizardPage_11);
        final ComboViewer versionViewer = new ComboViewer(container, 2060);
        versionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        versionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IScaSpecificationExtension) {
                    return ((IScaSpecificationExtension)element).getShortName();
                }
                return null;
            }
        });
        versionViewer.setInput(ScaExtensionManager.INSTANCE.getExtensionClasses());
        layoutData = new GridData();
        layoutData.widthHint = 240;
        versionViewer.getCombo().setLayoutData((Object)layoutData);
        new Label(container, 0).setText("");
        final Button createDiagramButton = new Button(container, 32);
        createDiagramButton.setSelection(this.createDiagram);
        createDiagramButton.setText(Messages.ScaCompsiteWizardPage_13);
        createDiagramButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScaCompsiteWizardPage.this.createDiagram = createDiagramButton.getSelection();
                ScaCompsiteWizardPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ScaCompsiteWizardPage.this.createDiagram = createDiagramButton.getSelection();
                ScaCompsiteWizardPage.this.validate();
            }
        });
        versionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)versionViewer.getSelection();
                if (!s.isEmpty()) {
                    ScaCompsiteWizardPage.this.selectedExtension = (IScaSpecificationExtension)s.getFirstElement();
                    boolean b = ScaCompsiteWizardPage.this.selectedExtension.canCreateCompositeDiagram();
                    createDiagramButton.setEnabled(b);
                    createDiagramButton.setSelection(b && ScaCompsiteWizardPage.this.createDiagram);
                    if (!b) {
                        ScaCompsiteWizardPage.this.createDiagram = false;
                    }
                    ScaCompsiteWizardPage.this.validate();
                }
            }
        });
        if (versionViewer.getCombo().getItemCount() > 0) {
            versionViewer.getCombo().select(0);
            versionViewer.getCombo().notifyListeners(13, new Event());
        }
        this.setControl((Control)container);
        String msg = this.getErrorMessage();
        if (msg != null) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
        }
    }

    private void validate() {
        String msg = null;
        if (this.compositeContainer == null) {
            msg = Messages.ScaCompsiteWizardPage_14;
        } else if (StringUtils.isEmpty(this.compositeName)) {
            msg = Messages.ScaCompsiteWizardPage_15;
        } else if (this.compositeContainer.getFile((IPath)new Path(String.valueOf(this.compositeName) + COMPOSITE_EXT)).exists()) {
            msg = NLS.bind((String)Messages.ScaCompsiteWizardPage_16, (Object)(String.valueOf(this.compositeName) + COMPOSITE_EXT));
        } else if (StringUtils.isEmpty(this.compositeTns)) {
            msg = Messages.ScaCompsiteWizardPage_18;
        } else if (this.selectedExtension == null) {
            msg = Messages.ScaCompsiteWizardPage_19;
        } else if (this.createDiagram && this.compositeContainer.getFile((IPath)new Path(String.valueOf(this.compositeName) + COMPOSITE_DIAG_EXT)).exists()) {
            msg = NLS.bind((String)Messages.ScaCompsiteWizardPage_16, (Object)(String.valueOf(this.compositeName) + COMPOSITE_DIAG_EXT));
        }
        this.setErrorMessage(msg);
        this.setPageComplete(msg == null);
    }

    public IScaSpecificationExtension getSelectedExtension() {
        return this.selectedExtension;
    }

    public boolean isDiagramToCreate() {
        return this.createDiagram;
    }

    public String getCompositeName() {
        return this.compositeName;
    }

    public String getCompositeTns() {
        return this.compositeTns;
    }

    public IContainer getCompositeContainer() {
        return this.compositeContainer;
    }
}

