/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.cdt.ui.ImageCache;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.BreakpointScopeCategory;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.Messages;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointScopeExtension;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointThreadFilterPage;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFContextQueryExpressionDialog;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IContextQuery;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFThreadFilterEditor {
    private TCFBreakpointThreadFilterPage fPage;
    private CheckboxTreeViewer fThreadViewer;
    private final ThreadFilterContentProvider fContentProvider;
    private final CheckHandler fCheckHandler;
    private final List<Context> fContexts = new ArrayList<Context>();
    private final Map<TCFLaunch, Context[]> fContainersPerLaunch = new HashMap<TCFLaunch, Context[]>();
    private final Map<Context, Context[]> fContextsPerContainer = new HashMap<Context, Context[]>();
    private StackLayout stackLayout;
    private Composite basicPage;
    private Composite advancedPage;
    private Combo scopeExprCombo;
    private ControlDecoration scopeExpressionDecoration;
    private Button radioBasic;
    private Button radioAdvanced;

    private IDialogSettings getDialogSettings(boolean create) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getClass().getName());
        if (section == null & create) {
            section = settings.addNewSection(this.getClass().getName());
        }
        return section;
    }

    public TCFThreadFilterEditor(Composite parent, TCFBreakpointThreadFilterPage page) {
        this.fPage = page;
        this.fContentProvider = new ThreadFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        buttonComposite.setLayoutData((Object)new GridData(768));
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setFont(parent.getFont());
        this.stackLayout = new StackLayout();
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)this.stackLayout);
        this.radioBasic = new Button(buttonComposite, 16);
        this.radioBasic.setText(Messages.TCFThreadFilterQueryButtonBasic);
        this.radioBasic.addSelectionListener((SelectionListener)new ScopingModeListener(mainComposite));
        this.radioAdvanced = new Button(buttonComposite, 16);
        this.radioAdvanced.setText(Messages.TCFThreadFilterQueryButtonAdvanced);
        this.radioAdvanced.addSelectionListener((SelectionListener)new ScopingModeListener(mainComposite));
        IDialogSettings settings = this.getDialogSettings(false);
        if (settings != null) {
            boolean basicSelected = settings.getBoolean(Messages.TCFThreadFilterQueryModeButtonState);
            if (basicSelected) {
                this.radioBasic.setSelection(true);
            } else {
                this.radioAdvanced.setSelection(true);
            }
        } else {
            this.radioBasic.setSelection(true);
        }
        this.createThreadViewer(mainComposite);
    }

    protected TCFBreakpointThreadFilterPage getPage() {
        return this.fPage;
    }

    private String getBPFilterExpression() {
        IMarker marker;
        String expression = null;
        ICBreakpoint bp = (ICBreakpoint)this.fPage.getElement().getAdapter(ICBreakpoint.class);
        if (bp != null && (marker = bp.getMarker()) != null) {
            try {
                expression = (String)marker.getAttribute("org.eclipse.tcf.debug.ContextQuery");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (this.fPage.getElement() instanceof BreakpointScopeCategory) {
            expression = ((BreakpointScopeCategory)this.fPage.getElement()).getFilter();
        }
        return expression;
    }

    private String[] getAvailableAttributes() {
        String[] result = null;
        TCFLaunch launch = (TCFLaunch)this.getAttributeLaunch();
        if (launch == null) {
            return result;
        }
        final IChannel channel = launch.getChannel();
        if (channel == null) {
            return result;
        }
        result = (String[])new TCFTask<String[]>(){

            public void run() {
                IContextQuery service = (IContextQuery)channel.getRemoteService(IContextQuery.class);
                service.getAttrNames(new IContextQuery.DoneGetAttrNames(){

                    public void doneGetAttrNames(IToken token, Exception error, String[] attributes) {
                        if (error != null) {
                            this.done(null);
                        }
                        this.done(attributes);
                    }
                });
            }
        }.getE();
        return result;
    }

    boolean missingParameterValue(String expression, int fromIndex) {
        boolean result = false;
        int lastIndex = expression.length();
        if (lastIndex != 0 && fromIndex <= lastIndex) {
            String failPattern = new String("[=,\\s]");
            int equalsIndex = expression.indexOf(61, fromIndex);
            int commaIndex = expression.indexOf(44, fromIndex);
            int nextEqualsIndex = expression.indexOf(61, equalsIndex + 1);
            if (commaIndex == lastIndex - 1 || equalsIndex == -1 || equalsIndex == lastIndex - 1) {
                return true;
            }
            String testChar = expression.substring(equalsIndex - 1, equalsIndex);
            String testNextChar = expression.substring(equalsIndex + 1, equalsIndex + 2);
            if (testChar.matches(failPattern) || testNextChar.matches(failPattern) || commaIndex != -1 && commaIndex < equalsIndex || nextEqualsIndex != -1 && (commaIndex == -1 || nextEqualsIndex < commaIndex)) {
                return true;
            }
            if (commaIndex != -1) {
                testChar = expression.substring(commaIndex - 1, commaIndex);
                testNextChar = expression.substring(commaIndex + 1, commaIndex + 2);
                if (testChar.matches(failPattern) || testNextChar.matches(failPattern)) {
                    return true;
                }
                result = this.missingParameterValue(expression, commaIndex + 1);
            }
        }
        return result;
    }

    private void setupScopeExpressionCombo(IDialogSettings settings, String bpContextQuery) {
        String[] expresionList = null;
        if (settings != null) {
            expresionList = settings.getArray(Messages.TCFThreadFilterQueryExpressionStore);
            if (expresionList != null) {
                int index = 0;
                while (index < expresionList.length) {
                    String member = expresionList[index];
                    if (member == null || member.length() == 0) break;
                    ++index;
                }
                String[] copyList = new String[index];
                int found = -1;
                int loop = 0;
                while (loop < index) {
                    copyList[loop] = expresionList[loop];
                    if (bpContextQuery != null && copyList[loop].equals(bpContextQuery)) {
                        found = loop;
                    }
                    ++loop;
                }
                if (found != -1) {
                    this.scopeExprCombo.setItems(copyList);
                    this.scopeExprCombo.select(found);
                } else {
                    int pad = 0;
                    if (bpContextQuery != null) {
                        pad = 1;
                    }
                    String[] setList = new String[index + pad];
                    if (bpContextQuery != null) {
                        setList[0] = bpContextQuery;
                    }
                    System.arraycopy(copyList, 0, setList, pad, copyList.length);
                    this.scopeExprCombo.setItems(setList);
                    if (bpContextQuery != null) {
                        this.scopeExprCombo.select(0);
                    }
                }
            } else if (bpContextQuery != null) {
                this.scopeExprCombo.setItems(new String[]{bpContextQuery});
                this.scopeExprCombo.select(0);
            }
        } else if (bpContextQuery != null) {
            this.scopeExprCombo.setItems(new String[]{bpContextQuery});
            this.scopeExprCombo.select(0);
        }
    }

    private void createThreadViewer(Composite parent) {
        GridData twoColumnLayout = new GridData(4, 0, true, false);
        twoColumnLayout.horizontalSpan = 2;
        this.advancedPage = new Composite(parent, 0);
        this.advancedPage.setLayout((Layout)new GridLayout(2, false));
        this.advancedPage.setFont(parent.getFont());
        Label epressionLabel = new Label(this.advancedPage, 0);
        epressionLabel.setText(Messages.TCFThreadFilterQueryAdvancedLabel);
        epressionLabel.setFont(this.advancedPage.getFont());
        epressionLabel.setLayoutData((Object)twoColumnLayout);
        this.scopeExprCombo = new Combo(this.advancedPage, 4);
        GridData comboGridData = new GridData(4, 0, true, false);
        comboGridData.horizontalIndent = 5;
        this.scopeExprCombo.setLayoutData((Object)comboGridData);
        this.scopeExprCombo.addModifyListener((ModifyListener)new ExpressionModifier());
        this.scopeExpressionDecoration = new ControlDecoration((Control)this.scopeExprCombo, 16384, this.advancedPage);
        this.scopeExpressionDecoration.hide();
        this.scopeExpressionDecoration.setDescriptionText(Messages.TCFThreadFilterEditorFormatError);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.scopeExpressionDecoration.setImage(fieldDecoration.getImage());
        String bpContextQuery = this.getBPFilterExpression();
        IDialogSettings settings = this.getDialogSettings(false);
        this.setupScopeExpressionCombo(settings, bpContextQuery);
        Button selectExpression = new Button(this.advancedPage, 8);
        selectExpression.setText(Messages.TCFThreadFilterQueryButtonEdit);
        selectExpression.setLayoutData((Object)new GridData(131072, 0, false, false));
        selectExpression.addListener(13, (Listener)new ExpressionSelectButton(parent.getShell()));
        this.basicPage = new Composite(parent, 0);
        this.basicPage.setLayout((Layout)new GridLayout(1, false));
        this.basicPage.setFont(parent.getFont());
        Label contextTreeLabel = new Label(this.basicPage, 0);
        contextTreeLabel.setText(Messages.TCFThreadFilterQueryTreeViewLabel);
        contextTreeLabel.setFont(this.basicPage.getFont());
        contextTreeLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fThreadViewer = new CheckboxTreeViewer(this.basicPage, 2048);
        this.fThreadViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fThreadViewer.getTree().setLayoutData((Object)data);
        this.fThreadViewer.getTree().setFont(this.basicPage.getFont());
        this.fThreadViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fThreadViewer.setLabelProvider((IBaseLabelProvider)new ThreadFilterLabelProvider());
        this.fThreadViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager());
        this.setInitialCheckedState();
        this.stackLayout.topControl = this.radioBasic.getSelection() ? this.basicPage : this.advancedPage;
        parent.layout();
    }

    protected ILaunch getAttributeLaunch() {
        IAdaptable dbgContext = DebugUITools.getDebugContext();
        return (ILaunch)dbgContext.getAdapter(ILaunch.class);
    }

    protected ILaunch[] getLaunches() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new ILaunch[0];
        }
        ArrayList<ILaunch> tcfLaunches = new ArrayList<ILaunch>();
        ILaunch[] launches = ((ILaunchManager)input).getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch instanceof TCFLaunch && !launch.isTerminated()) {
                tcfLaunches.add(launch);
            }
            ++i;
        }
        return tcfLaunches.toArray(new ILaunch[tcfLaunches.size()]);
    }

    protected Context[] getRootContexts() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new Context[0];
        }
        ArrayList<Context> targets = new ArrayList<Context>();
        ILaunch[] launches = ((ILaunchManager)input).getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch instanceof TCFLaunch && !launch.isTerminated()) {
                Context[] targetArray = this.syncGetContainers((TCFLaunch)launch);
                targets.addAll(Arrays.asList(targetArray));
            }
            ++i;
        }
        return targets.toArray(new Context[targets.size()]);
    }

    protected final CheckboxTreeViewer getThreadViewer() {
        return this.fThreadViewer;
    }

    protected final String getScopeExpression() {
        return this.scopeExprCombo.getText();
    }

    protected void setInitialCheckedState() {
        TCFBreakpointScopeExtension filterExtension = this.fPage.getFilterExtension();
        if (filterExtension == null) {
            return;
        }
        String[] ctxIds = filterExtension.getThreadFilters();
        this.getThreadViewer().expandAll();
        if (ctxIds == null) {
            ILaunch[] launches;
            ILaunch[] iLaunchArray = launches = this.getLaunches();
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                this.fCheckHandler.checkLaunch(launch, true);
                ++n2;
            }
        } else if (ctxIds.length != 0) {
            int i = 0;
            while (i < ctxIds.length) {
                String id = ctxIds[i];
                Context ctx = this.getContext(id);
                if (ctx != null) {
                    this.fCheckHandler.checkContext(ctx, true);
                    this.fCheckHandler.updateParentCheckState(ctx);
                } else if (id.indexOf(47) < 0) {
                    for (Context context : this.fContexts) {
                        if (!id.equals(context.fId)) continue;
                        this.fCheckHandler.checkContext(context, true);
                        this.fCheckHandler.updateParentCheckState(context);
                    }
                }
                ++i;
            }
        }
        this.getThreadViewer().setExpandedElements(this.getThreadViewer().getCheckedElements());
    }

    private Context getContainer(Context child) {
        String parentId = child.fSessionId != null ? String.valueOf(child.fSessionId) + '/' + child.fParentId : child.fParentId;
        return this.getContext(parentId);
    }

    private Context getContext(String id) {
        for (Context ctx : this.fContexts) {
            if (!ctx.fScopeId.equals(id)) continue;
            return ctx;
        }
        return null;
    }

    void updateExpressionsDialogSettings(IDialogSettings settings, String scopedExpression) {
        String[] list = settings.getArray(Messages.TCFThreadFilterQueryExpressionStore);
        if (list == null) {
            list = new String[20];
        }
        int i = 0;
        while (i < list.length) {
            String member = list[i];
            if (member != null && member.equals(scopedExpression)) {
                return;
            }
            if (member == null) {
                list[i] = scopedExpression;
                settings.put(Messages.TCFThreadFilterQueryExpressionStore, list);
                return;
            }
            ++i;
        }
        String[] copyList = new String[20];
        copyList[0] = scopedExpression;
        System.arraycopy(list, 0, copyList, 1, list.length - 1);
        settings.put(Messages.TCFThreadFilterQueryExpressionStore, copyList);
    }

    protected void doStore() {
        IDialogSettings settings = this.getDialogSettings(true);
        if (settings != null) {
            settings.put(Messages.TCFThreadFilterQueryModeButtonState, this.radioBasic.getSelection());
        }
        if (this.radioAdvanced.getSelection()) {
            String scopedExpression = this.getScopeExpression();
            this.updateExpressionsDialogSettings(settings, scopedExpression);
            TCFBreakpointScopeExtension filterExtension = this.fPage.getFilterExtension();
            if (filterExtension == null) {
                return;
            }
            filterExtension.setPropertiesFilter(scopedExpression);
            filterExtension.setThreadFilter(null);
        } else if (this.radioBasic.getSelection()) {
            CheckboxTreeViewer viewer = this.getThreadViewer();
            Object[] elements = viewer.getCheckedElements();
            ArrayList<String> checkedIds = new ArrayList<String>();
            int i = 0;
            while (i < elements.length) {
                Context ctx;
                if (elements[i] instanceof Context && !viewer.getGrayed((Object)(ctx = (Context)elements[i]))) {
                    checkedIds.add(ctx.fScopeId);
                }
                ++i;
            }
            String[] threadIds = checkedIds.size() == this.fContexts.size() ? null : checkedIds.toArray(new String[checkedIds.size()]);
            TCFBreakpointScopeExtension filterExtension = this.fPage.getFilterExtension();
            if (filterExtension == null) {
                return;
            }
            filterExtension.setThreadFilter(threadIds);
            filterExtension.setPropertiesFilter(null);
        }
    }

    private Context[] syncGetContainers(final TCFLaunch launch) {
        Context[] result = this.fContainersPerLaunch.get(launch);
        if (result != null) {
            return result;
        }
        final String launchCfgName = launch.getLaunchConfiguration().getName();
        result = (Context[])new TCFTask<Context[]>(launch.getChannel()){

            public void run() {
                ArrayList<Context> containers = new ArrayList<Context>();
                TCFChildren children = TCFModelManager.getModelManager().getRootNode(launch).getChildren();
                if (!children.validate((Runnable)((Object)this))) {
                    return;
                }
                Map childMap = (Map)children.getData();
                for (TCFNode node : childMap.values()) {
                    if (!(node instanceof TCFNodeExecContext)) continue;
                    TCFNodeExecContext exeCtx = (TCFNodeExecContext)node;
                    TCFDataCache runCtxCache = exeCtx.getRunContext();
                    if (!runCtxCache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)runCtxCache.getData();
                    containers.add(new Context(runCtx, launchCfgName));
                }
                this.done(containers.toArray(new Context[containers.size()]));
            }
        }.getE();
        this.fContexts.addAll(Arrays.asList(result));
        this.fContainersPerLaunch.put(launch, result);
        return result;
    }

    private Context[] syncGetThreads(final Context container) {
        Context[] result = this.fContextsPerContainer.get(container);
        if (result != null) {
            return result;
        }
        final TCFLaunch launch = this.getLaunch(container);
        result = (Context[])new TCFTask<Context[]>(launch.getChannel()){

            public void run() {
                ArrayList<Context> contexts = new ArrayList<Context>();
                TCFModel model = TCFModelManager.getModelManager().getModel(launch);
                TCFChildren children = ((TCFNodeExecContext)model.getNode(container.fId)).getChildren();
                if (!children.validate((Runnable)((Object)this))) {
                    return;
                }
                Collection childNodes = ((Map)children.getData()).values();
                Object[] nodes = childNodes.toArray(new TCFNode[childNodes.size()]);
                Arrays.sort(nodes);
                Object[] objectArray = nodes;
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    Object node = objectArray[n2];
                    if (node instanceof TCFNodeExecContext) {
                        TCFNodeExecContext exeCtx = (TCFNodeExecContext)node;
                        TCFDataCache runCtxCache = exeCtx.getRunContext();
                        if (!runCtxCache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        IRunControl.RunControlContext runCtx = (IRunControl.RunControlContext)runCtxCache.getData();
                        contexts.add(new Context(runCtx, container));
                    }
                    ++n2;
                }
                this.done(contexts.toArray(new Context[contexts.size()]));
            }
        }.getE();
        this.fContextsPerContainer.put(container, result);
        this.fContexts.addAll(Arrays.asList(result));
        return result;
    }

    private TCFLaunch getLaunch(Context container) {
        Context parent = this.getContainer(container);
        while (parent != null) {
            container = parent;
            parent = this.getContainer(container);
        }
        for (TCFLaunch launch : this.fContainersPerLaunch.keySet()) {
            Context[] containers;
            Context[] contextArray = containers = this.fContainersPerLaunch.get(launch);
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                Context context = contextArray[n2];
                if (context.fScopeId.equals(container.fScopeId)) {
                    return launch;
                }
                ++n2;
            }
        }
        return null;
    }

    public class CheckHandler
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            if (checked) {
                TCFThreadFilterEditor.this.getThreadViewer().expandToLevel(element, 1);
            }
            if (element instanceof Context) {
                Context ctx = (Context)element;
                this.checkContext(ctx, checked);
                this.updateParentCheckState(ctx);
            } else if (element instanceof ILaunch) {
                this.checkLaunch((ILaunch)element, checked);
            }
        }

        private void checkLaunch(ILaunch launch, boolean checked) {
            TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)launch, checked);
            TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)launch, false);
            Context[] threads = TCFThreadFilterEditor.this.syncGetContainers((TCFLaunch)launch);
            int i = 0;
            while (i < threads.length) {
                this.checkContext(threads[i], checked);
                ++i;
            }
        }

        private void checkContext(Context ctx, boolean checked) {
            if (ctx.fIsContainer) {
                Context[] threads = TCFThreadFilterEditor.this.syncGetThreads(ctx);
                int i = 0;
                while (i < threads.length) {
                    this.checkContext(threads[i], checked);
                    ++i;
                }
            }
            this.checkThread(ctx, checked);
        }

        private void checkThread(Context thread, boolean checked) {
            TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)thread, checked);
            TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)thread, false);
        }

        private void updateParentCheckState(Context thread) {
            Context[] threads;
            Context parent = TCFThreadFilterEditor.this.getContainer(thread);
            if (parent == null) {
                parent = TCFThreadFilterEditor.this.getLaunch(thread);
                if (parent == null) {
                    return;
                }
                threads = TCFThreadFilterEditor.this.syncGetContainers((TCFLaunch)parent);
            } else {
                threads = TCFThreadFilterEditor.this.syncGetThreads(parent);
            }
            int checkedNumber = 0;
            int grayedNumber = 0;
            int i = 0;
            while (i < threads.length) {
                if (TCFThreadFilterEditor.this.getThreadViewer().getGrayed((Object)threads[i])) {
                    ++grayedNumber;
                } else if (TCFThreadFilterEditor.this.getThreadViewer().getChecked((Object)threads[i])) {
                    ++checkedNumber;
                }
                ++i;
            }
            if (checkedNumber + grayedNumber == 0) {
                TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)parent, false);
                TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)parent, false);
            } else if (checkedNumber == threads.length) {
                TCFThreadFilterEditor.this.getThreadViewer().setChecked((Object)parent, true);
                TCFThreadFilterEditor.this.getThreadViewer().setGrayed((Object)parent, false);
            } else {
                TCFThreadFilterEditor.this.getThreadViewer().setGrayChecked((Object)parent, true);
            }
            if (parent instanceof Context) {
                this.updateParentCheckState(parent);
            }
        }
    }

    private static class Context {
        private final String fName;
        private final String fId;
        private final String fParentId;
        private final boolean fIsContainer;
        private final String fScopeId;
        private final String fSessionId;
        private final String fBpGroup;

        Context(IRunControl.RunControlContext ctx, Context parent) {
            this(ctx, parent.fSessionId);
        }

        Context(IRunControl.RunControlContext ctx, String sessionId) {
            String name;
            this.fName = name = ctx.getName() != null ? ctx.getName() : ctx.getID();
            this.fSessionId = sessionId;
            this.fScopeId = sessionId != null ? String.valueOf(sessionId) + '/' + ctx.getID() : ctx.getID();
            this.fId = ctx.getID();
            this.fParentId = ctx.getParentID();
            this.fIsContainer = ctx.isContainer();
            this.fBpGroup = ctx.getBPGroup();
        }
    }

    private class ExpressionModifier
    implements ModifyListener {
        private ExpressionModifier() {
        }

        public void modifyText(ModifyEvent e) {
            String expression = TCFThreadFilterEditor.this.scopeExprCombo.getText();
            if (TCFThreadFilterEditor.this.missingParameterValue(expression, 0)) {
                TCFThreadFilterEditor.this.scopeExpressionDecoration.show();
                TCFThreadFilterEditor.this.fPage.setErrorMessage(Messages.TCFThreadFilterEditorFormatError);
                TCFThreadFilterEditor.this.fPage.setValid(false);
            } else {
                TCFThreadFilterEditor.this.scopeExpressionDecoration.hide();
                TCFThreadFilterEditor.this.fPage.setErrorMessage(null);
                TCFThreadFilterEditor.this.fPage.setValid(true);
            }
        }
    }

    private class ExpressionSelectButton
    implements Listener {
        private Shell parentShell;

        public ExpressionSelectButton(Shell shell) {
            this.parentShell = shell;
        }

        public void handleEvent(Event event) {
            String[] attrsList = TCFThreadFilterEditor.this.getAvailableAttributes();
            String result = null;
            TCFContextQueryExpressionDialog dlg = new TCFContextQueryExpressionDialog(this.parentShell, attrsList, TCFThreadFilterEditor.this.scopeExprCombo.getText());
            if (dlg.open() == 0) {
                result = dlg.getExpression();
            }
            if (result != null) {
                TCFThreadFilterEditor.this.scopeExprCombo.setText(result);
            }
        }
    }

    public class ScopingModeListener
    implements SelectionListener {
        private Composite fParent;

        public ScopingModeListener(Composite parent) {
            this.fParent = parent;
        }

        public void widgetSelected(SelectionEvent e) {
            ((TCFThreadFilterEditor)TCFThreadFilterEditor.this).stackLayout.topControl = TCFThreadFilterEditor.this.radioBasic.getSelection() ? TCFThreadFilterEditor.this.basicPage : TCFThreadFilterEditor.this.advancedPage;
            this.fParent.layout();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ThreadFilterContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parent) {
            if (parent instanceof Context) {
                Context[] children = TCFThreadFilterEditor.this.syncGetThreads((Context)parent);
                return this.filterBPGroupContexts(children);
            }
            if (parent instanceof ILaunch) {
                Context[] children = TCFThreadFilterEditor.this.syncGetContainers((TCFLaunch)parent);
                return this.filterBPGroupContexts(children);
            }
            if (parent instanceof ILaunchManager) {
                return TCFThreadFilterEditor.this.getLaunches();
            }
            return new Object[0];
        }

        private Context[] filterBPGroupContexts(Context[] children) {
            ArrayList<Context> filteredChildren = new ArrayList<Context>(children.length);
            Context[] contextArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Context child = contextArray[n2];
                if (child.fBpGroup != null || this.getChildren(child).length != 0) {
                    filteredChildren.add(child);
                }
                ++n2;
            }
            if (filteredChildren.size() == children.length) {
                return children;
            }
            return filteredChildren.toArray(new Context[filteredChildren.size()]);
        }

        public Object getParent(Object element) {
            if (element instanceof Context) {
                Context ctx = (Context)element;
                if (ctx.fParentId == null) {
                    return DebugPlugin.getDefault().getLaunchManager();
                }
                return TCFThreadFilterEditor.this.getContainer(ctx);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ThreadFilterLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            ImageDescriptor desc;
            if (element instanceof Context) {
                Context ctx = (Context)element;
                if (ctx.fIsContainer) {
                    return DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET");
                }
                return DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING");
            }
            if (element instanceof ILaunch && (desc = DebugUITools.getDefaultImageDescriptor((Object)element)) != null) {
                return ImageCache.getImage(desc);
            }
            return null;
        }

        public String getText(Object element) {
            ILaunchConfiguration config;
            if (element instanceof Context) {
                Context ctx = (Context)element;
                return ctx.fName;
            }
            if (element instanceof ILaunch && (config = ((ILaunch)element).getLaunchConfiguration()) != null) {
                return config.getName();
            }
            return "?";
        }
    }
}

