/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.launch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;

public class ProcessListControl {
    private Tree fProcessTree;
    private Display display;
    private IPeer fPeer;
    private final ProcessInfo root_info = new ProcessInfo();
    private IChannel fChannel;
    private IProcesses fProcesses;
    protected final ProcessListener fProcessListener = new ProcessListener();
    private String fContextToSelect;
    private LinkedList<String> fPathToSelect;
    private Composite fComposite;

    public ProcessListControl(Composite parent) {
        this.display = parent.getDisplay();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProcessListControl.this.handleDispose();
            }
        });
        this.createProcessListArea(parent);
    }

    public void setInput(IPeer peer) {
        if (peer == this.fPeer) {
            return;
        }
        if (this.fPeer != null) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    ProcessListControl.this.disconnectPeer();
                }
            });
        }
        this.fProcessTree.setItemCount(0);
        this.root_info.children = null;
        this.fPeer = peer;
        if (this.fPeer != null) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    ProcessListControl.this.connectPeer();
                }
            });
        }
    }

    public Control getControl() {
        return this.fComposite;
    }

    public Tree getTree() {
        return this.fProcessTree;
    }

    public ProcessInfo getSelection() {
        TreeItem[] items;
        if (this.fProcessTree != null && (items = this.fProcessTree.getSelection()).length > 0) {
            ProcessInfo info = this.findProcessInfo(items[0]);
            return info;
        }
        return null;
    }

    private void createProcessListArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setFont(font);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fComposite = composite;
        this.fProcessTree = new Tree(composite, 268437508);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 150;
        gd.minimumWidth = 470;
        this.fProcessTree.setLayoutData((Object)gd);
        this.fProcessTree.setFont(font);
        this.fProcessTree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                ProcessInfo info = ProcessListControl.this.findProcessInfo(item);
                if (info == null) {
                    ProcessListControl.this.updateItems(item.getParentItem(), false);
                } else {
                    ProcessListControl.this.fillItem(item, info);
                }
            }
        });
    }

    private void handleDispose() {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                ProcessListControl.this.disconnectPeer();
                if (ProcessListControl.this.fProcesses != null) {
                    ProcessListControl.this.fProcesses.removeListener((IProcesses.ProcessesListener)ProcessListControl.this.fProcessListener);
                    ProcessListControl.this.fProcesses = null;
                }
                ProcessListControl.this.display = null;
            }
        });
    }

    protected void disconnectPeer() {
        if (this.fChannel != null && this.fChannel.getState() != 2) {
            this.fChannel.close();
        }
    }

    protected void connectPeer() {
        IChannel channel;
        this.fChannel = channel = this.fPeer.openChannel();
        this.fProcesses = null;
        channel.addChannelListener(new IChannel.IChannelListener(){

            public void congestionLevel(int level) {
            }

            public void onChannelClosed(final Throwable error) {
                if (ProcessListControl.this.fChannel != channel) {
                    return;
                }
                ProcessListControl.this.fChannel = null;
                if (ProcessListControl.this.display != null) {
                    ProcessListControl.this.display.asyncExec(new Runnable(){

                        public void run() {
                            if (((ProcessListControl)(this).ProcessListControl.this).root_info.children_pending) {
                                return;
                            }
                            ((ProcessListControl)(this).ProcessListControl.this).root_info.children = null;
                            ((ProcessListControl)(this).ProcessListControl.this).root_info.children_error = error;
                            ProcessListControl.this.updateItems(ProcessListControl.this.root_info);
                        }
                    });
                }
            }

            public void onChannelOpened() {
                if (ProcessListControl.this.fChannel != channel) {
                    return;
                }
                ProcessListControl.this.fProcesses = (IProcesses)ProcessListControl.this.fChannel.getRemoteService(IProcesses.class);
                if (ProcessListControl.this.fProcesses != null) {
                    ProcessListControl.this.fProcesses.addListener((IProcesses.ProcessesListener)ProcessListControl.this.fProcessListener);
                    if (ProcessListControl.this.fContextToSelect != null) {
                        final LinkedList<String> contextPath = new LinkedList<String>();
                        contextPath.addFirst(ProcessListControl.this.fContextToSelect);
                        ProcessListControl.this.fProcesses.getContext(ProcessListControl.this.fContextToSelect, new IProcesses.DoneGetContext(){

                            public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                if (error == null) {
                                    String parentId = context.getParentID();
                                    if (parentId != null) {
                                        contextPath.addFirst(parentId);
                                        ProcessListControl.this.fProcesses.getContext(parentId, (IProcesses.DoneGetContext)this);
                                        return;
                                    }
                                    if (ProcessListControl.this.display != null) {
                                        ProcessListControl.this.display.asyncExec(new Runnable(){

                                            public void run() {
                                                ProcessListControl.this.fPathToSelect = contextPath;
                                                ProcessListControl.this.expandSelect();
                                            }
                                        });
                                    }
                                }
                            }
                        });
                    }
                }
                if (ProcessListControl.this.display != null) {
                    ProcessListControl.this.display.asyncExec(new Runnable(){

                        public void run() {
                            if (((ProcessListControl)(this).ProcessListControl.this).root_info.children_pending) {
                                return;
                            }
                            ((ProcessListControl)(this).ProcessListControl.this).root_info.children = null;
                            ((ProcessListControl)(this).ProcessListControl.this).root_info.children_error = null;
                            ProcessListControl.this.updateItems(ProcessListControl.this.root_info);
                        }
                    });
                }
            }
        });
    }

    private void updateItems(TreeItem parent_item, boolean reload) {
        final ProcessInfo parent_info = this.findProcessInfo(parent_item);
        if (parent_info == null) {
            parent_item.setText("Invalid");
        } else {
            if (reload && parent_info.children_error != null) {
                this.loadChildren(parent_info);
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    ProcessListControl.this.updateItems(parent_info);
                }
            });
        }
    }

    private void updateItems(ProcessInfo parent) {
        if (this.display == null) {
            return;
        }
        assert (Thread.currentThread() == this.display.getThread());
        TreeItem[] items = null;
        boolean expanded = true;
        if (parent.children == null || parent.children_error != null) {
            if (parent == this.root_info) {
                this.fProcessTree.setItemCount(1);
                items = this.fProcessTree.getItems();
            } else {
                TreeItem item = this.findItem(parent);
                if (item == null) {
                    return;
                }
                expanded = item.getExpanded();
                item.setItemCount(1);
                items = item.getItems();
            }
            assert (items.length == 1);
            items[0].removeAll();
            if (parent.children_pending) {
                items[0].setForeground(this.display.getSystemColor(24));
                items[0].setText("Pending...");
            } else if (parent.children_error != null) {
                String msg = parent.children_error.getMessage();
                msg = msg == null ? parent.children_error.getClass().getName() : msg.replace('\n', ' ');
                items[0].setForeground(this.display.getSystemColor(3));
                items[0].setText(msg);
                items[0].setImage(null);
            } else if (expanded) {
                this.loadChildren(parent);
                items[0].setForeground(this.display.getSystemColor(24));
                items[0].setText("Pending...");
            } else {
                items[0].setText("");
            }
        } else {
            ProcessInfo[] arr = parent.children;
            if (parent == this.root_info) {
                this.fProcessTree.setItemCount(arr.length);
                items = this.fProcessTree.getItems();
            } else {
                TreeItem item = this.findItem(parent);
                if (item == null) {
                    return;
                }
                expanded = item.getExpanded();
                item.setItemCount(expanded ? arr.length : 1);
                items = item.getItems();
            }
            if (expanded) {
                assert (items.length == arr.length);
                int i = 0;
                while (i < items.length) {
                    this.fillItem(items[i], arr[i]);
                    ++i;
                }
                if (items.length == 1 && !items[0].getExpanded()) {
                    items[0].setExpanded(true);
                }
                this.expandSelect();
            } else {
                items[0].setText("");
            }
        }
    }

    private void expandSelect() {
        TreeItem item;
        String id;
        ProcessInfo info;
        if (this.fPathToSelect == null) {
            return;
        }
        if (this.fPathToSelect.isEmpty()) {
            this.fPathToSelect = null;
            this.fContextToSelect = null;
            return;
        }
        while ((info = this.findProcessInfo(this.root_info, id = this.fPathToSelect.get(0))) != null && (item = this.findItem(info)) != null) {
            this.fPathToSelect.removeFirst();
            if (this.fPathToSelect.isEmpty()) {
                this.fProcessTree.setSelection(item);
            } else {
                item.setExpanded(true);
            }
            if (!this.fPathToSelect.isEmpty()) continue;
        }
    }

    private void loadChildren(final ProcessInfo parent) {
        assert (Thread.currentThread() == this.display.getThread());
        if (parent.children_pending) {
            return;
        }
        assert (parent.children == null);
        parent.children_pending = true;
        parent.children_error = null;
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                final IProcesses proc = ProcessListControl.this.fProcesses;
                if (proc == null || !ProcessListControl.this.canHaveChildren(parent)) {
                    ProcessListControl.this.doneLoadChildren(parent, null, new ProcessInfo[0]);
                } else {
                    proc.getChildren(parent.id, false, new IProcesses.DoneGetChildren(){

                        public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                            if (error != null) {
                                ProcessListControl.this.doneLoadChildren(parent, error, null);
                            } else if (context_ids.length > 0) {
                                final ArrayList contextInfos = new ArrayList(context_ids.length);
                                final HashSet<IToken> pending = new HashSet<IToken>();
                                String[] stringArray = context_ids;
                                int n = context_ids.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String id = stringArray[n2];
                                    pending.add(proc.getContext(id, new IProcesses.DoneGetContext(){

                                        public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                            if (context != null) {
                                                ProcessInfo info = new ProcessInfo();
                                                info.parent = parent;
                                                info.id = context.getID();
                                                info.name = context.getName();
                                                info.name = info.name == null || info.name.length() == 0 ? info.id : String.valueOf(info.name) + " [" + info.id + ']';
                                                info.isContainer = false;
                                                info.isAttached = context.isAttached();
                                                info.index = contextInfos.size();
                                                contextInfos.add(info);
                                            }
                                            pending.remove(token);
                                            if (pending.isEmpty()) {
                                                ProcessListControl.this.doneLoadChildren(parent, null, contextInfos.toArray(new ProcessInfo[contextInfos.size()]));
                                            }
                                        }
                                    }));
                                    ++n2;
                                }
                            } else {
                                ProcessListControl.this.doneLoadChildren(parent, null, new ProcessInfo[0]);
                            }
                        }
                    });
                }
            }
        });
    }

    private void doneLoadChildren(final ProcessInfo parent, final Throwable error, final ProcessInfo[] children) {
        assert (Protocol.isDispatchThread());
        assert (error == null || children == null);
        if (this.display == null) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!$assertionsDisabled && !parent.children_pending) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && parent.children != null) {
                    throw new AssertionError();
                }
                parent.children_pending = false;
                parent.children = children;
                parent.children_error = error;
                ProcessListControl.this.updateItems(parent);
            }
        });
    }

    public ProcessInfo findProcessInfo(TreeItem item) {
        int i;
        assert (Thread.currentThread() == this.display.getThread());
        if (item == null) {
            return this.root_info;
        }
        TreeItem parent = item.getParentItem();
        ProcessInfo info = this.findProcessInfo(parent);
        if (info == null) {
            return null;
        }
        if (info.children == null) {
            return null;
        }
        if (info.children_error != null) {
            return null;
        }
        int n = i = parent == null ? this.fProcessTree.indexOf(item) : parent.indexOf(item);
        if (i < 0 || i >= info.children.length) {
            return null;
        }
        assert (info.children[i].index == i);
        return info.children[i];
    }

    public ProcessInfo findProcessInfo(ProcessInfo parent, String id) {
        assert (Thread.currentThread() == this.display.getThread());
        if (id == null) {
            return this.root_info;
        }
        if (id.equals(parent.id)) {
            return parent;
        }
        ProcessInfo[] childInfos = parent.children;
        if (childInfos != null) {
            ProcessInfo[] processInfoArray = childInfos;
            int n = childInfos.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessInfo contextInfo = processInfoArray[n2];
                ProcessInfo found = this.findProcessInfo(contextInfo, id);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        }
        return null;
    }

    private TreeItem findItem(ProcessInfo info) {
        if (info == null) {
            return null;
        }
        assert (info.parent != null);
        if (info.parent == this.root_info) {
            int n = this.fProcessTree.getItemCount();
            if (info.index >= n) {
                return null;
            }
            return this.fProcessTree.getItem(info.index);
        }
        TreeItem i = this.findItem(info.parent);
        if (i == null) {
            return null;
        }
        int n = i.getItemCount();
        if (info.index >= n) {
            return null;
        }
        return i.getItem(info.index);
    }

    private void fillItem(TreeItem item, ProcessInfo info) {
        assert (Thread.currentThread() == this.display.getThread());
        Object data = item.getData("TCFContextInfo");
        if (data != null && data != info) {
            item.removeAll();
        }
        item.setData("TCFContextInfo", (Object)info);
        String text = info.name != null ? info.name : info.id;
        item.setText(text);
        item.setForeground(this.display.getSystemColor(24));
        item.setImage(this.getImage(info));
        if (!this.canHaveChildren(info)) {
            item.setItemCount(0);
        } else if (info.children == null || info.children_error != null) {
            item.setItemCount(1);
        } else {
            item.setItemCount(info.children.length);
        }
    }

    private boolean canHaveChildren(ProcessInfo info) {
        return info.isContainer || info == this.root_info;
    }

    private Image getImage(ProcessInfo info) {
        return DebugUITools.getImage((String)"IMG_OBJS_OS_PROCESS");
    }

    public void selectContext(final String contextId) {
        this.fPathToSelect = null;
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                ProcessListControl.this.fContextToSelect = contextId;
            }
        });
    }

    static class ProcessInfo {
        String name;
        String id;
        boolean isContainer;
        ProcessInfo[] children;
        Throwable children_error;
        int index;
        boolean children_pending;
        ProcessInfo parent;
        protected boolean isAttached;

        ProcessInfo() {
        }
    }

    private final class ProcessListener
    implements IProcesses.ProcessesListener {
        private ProcessListener() {
        }

        public void exited(final String process_id, int exit_code) {
            if (ProcessListControl.this.display != null) {
                ProcessListControl.this.display.asyncExec(new Runnable(){

                    public void run() {
                        ProcessInfo info = ProcessListControl.this.findProcessInfo(ProcessListControl.this.root_info, process_id);
                        if (info != null && info.parent != null && info.parent.children != null) {
                            info.parent.children = null;
                            ProcessListControl.this.loadChildren(info.parent);
                        }
                    }
                });
            }
        }
    }
}

