/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.tcf.internal.services.local.DiagnosticsService;
import org.eclipse.tcf.internal.services.remote.GenericProxy;
import org.eclipse.tcf.internal.services.remote.LocatorProxy;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IServiceProvider;
import org.eclipse.tcf.protocol.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManager {
    private static final Collection<IServiceProvider> providers = new ArrayList<IServiceProvider>();

    static {
        ServiceManager.addServiceProvider(new IServiceProvider(){
            private final String package_name = LocatorProxy.class.getPackage().getName();

            public IService[] getLocalService(IChannel channel) {
                return new IService[]{new DiagnosticsService(channel)};
            }

            public IService getServiceProxy(IChannel channel, String service_name) {
                IService service = null;
                try {
                    Class<?> cls = Class.forName(String.valueOf(this.package_name) + "." + service_name + "Proxy");
                    service = (IService)cls.getConstructor(IChannel.class).newInstance(channel);
                    if (!$assertionsDisabled && !service_name.equals(service.getName())) {
                        throw new AssertionError();
                    }
                }
                catch (Exception exception) {}
                return service;
            }
        });
    }

    public static String getID() {
        return Protocol.getAgentID();
    }

    public static synchronized void addServiceProvider(IServiceProvider provider) {
        providers.add(provider);
    }

    public static synchronized void removeServiceProvider(IServiceProvider provider) {
        providers.remove(provider);
    }

    public static synchronized void onChannelCreated(IChannel channel, Map<String, IService> services) {
        IService zero_copy = new IService(){

            public String getName() {
                return "ZeroCopy";
            }
        };
        services.put(zero_copy.getName(), zero_copy);
        for (IServiceProvider provider : providers) {
            try {
                IService[] arr = provider.getLocalService(channel);
                if (arr == null) continue;
                IService[] iServiceArray = arr;
                int n = arr.length;
                int n2 = 0;
                while (n2 < n) {
                    IService service = iServiceArray[n2];
                    if (!services.containsKey(service.getName())) {
                        services.put(service.getName(), service);
                    }
                    ++n2;
                }
            }
            catch (Throwable x) {
                Protocol.log("Error calling TCF service provider", x);
            }
        }
    }

    public static synchronized void onChannelOpened(IChannel channel, Collection<String> service_names, Map<String, IService> services) {
        for (String name : service_names) {
            for (IServiceProvider provider : providers) {
                try {
                    IService service = provider.getServiceProxy(channel, name);
                    if (service == null) continue;
                    services.put(name, service);
                    break;
                }
                catch (Throwable x) {
                    Protocol.log("Error calling TCF service provider", x);
                }
            }
            if (services.containsKey(name)) continue;
            services.put(name, new GenericProxy(channel, name));
        }
    }
}

