/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.protocol;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IChannel {
    public static final int STATE_OPENING = 0;
    public static final int STATE_OPEN = 1;
    public static final int STATE_CLOSED = 2;
    public static final int STATE_OPENNING = 0;

    public int getState();

    public IToken sendCommand(IService var1, String var2, byte[] var3, ICommandListener var4);

    public void sendResult(IToken var1, byte[] var2);

    public void rejectCommand(IToken var1);

    public int getCongestion();

    public void addChannelListener(IChannelListener var1);

    public void removeChannelListener(IChannelListener var1);

    public void addCommandServer(IService var1, ICommandServer var2);

    public void removeCommandServer(IService var1, ICommandServer var2);

    public void addEventListener(IService var1, IEventListener var2);

    public void removeEventListener(IService var1, IEventListener var2);

    public IPeer getLocalPeer();

    public IPeer getRemotePeer();

    public Collection<String> getLocalServices();

    public IService getLocalService(String var1);

    public <V extends IService> V getLocalService(Class<V> var1);

    public Collection<String> getRemoteServices();

    public IService getRemoteService(String var1);

    public <V extends IService> V getRemoteService(Class<V> var1);

    public <V extends IService> void setServiceProxy(Class<V> var1, IService var2);

    public void close();

    public void terminate(Throwable var1);

    public void redirect(String var1);

    public void redirect(Map<String, String> var1);

    public static interface IChannelListener {
        public void onChannelOpened();

        public void onChannelClosed(Throwable var1);

        public void congestionLevel(int var1);
    }

    public static interface ICommandListener {
        public void progress(IToken var1, byte[] var2);

        public void result(IToken var1, byte[] var2);

        public void terminated(IToken var1, Exception var2);
    }

    public static interface ICommandServer {
        public void command(IToken var1, String var2, byte[] var3);
    }

    public static interface IEventListener {
        public void event(String var1, byte[] var2);
    }
}

