/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class DetachCommand
extends AbstractActionDelegate {
    private static boolean run(TCFNode[] nodes, final boolean dry_run) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        TCFNode[] tCFNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            boolean ok = false;
            while (!ok && n3 != null) {
                if (n3 instanceof TCFNodeExecContext) {
                    final TCFNodeExecContext exe = (TCFNodeExecContext)n3;
                    ok = (Boolean)new TCFTask<Boolean>(n3.getChannel()){

                        public void run() {
                            TCFDataCache<IRunControl.RunControlContext> ctx_cache = exe.getRunContext();
                            if (!ctx_cache.validate((Runnable)((Object)this))) {
                                return;
                            }
                            IRunControl.RunControlContext ctx_data = (IRunControl.RunControlContext)ctx_cache.getData();
                            if (ctx_data != null && ctx_data.canDetach()) {
                                if (dry_run) {
                                    this.done(true);
                                } else {
                                    ctx_data.detach(new IRunControl.DoneCommand(){

                                        public void doneCommand(IToken token, Exception error) {
                                            if (error != null) {
                                                this.error(error);
                                            } else {
                                                exe.getModel().getLaunch().onDetach(exe.getID());
                                                this.done(true);
                                            }
                                        }
                                    });
                                }
                            } else {
                                this.done(false);
                            }
                        }
                    }.getE();
                }
                n3 = n3.getParent();
            }
            if (!ok) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void selectionChanged() {
        this.getAction().setEnabled(DetachCommand.run(this.getSelectedNodes(), true));
    }

    protected void run() {
        TCFNode[] nodes = this.getSelectedNodes();
        if (!DetachCommand.run(nodes, true)) {
            return;
        }
        DetachCommand.run(nodes, false);
    }
}

