/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestErrorsDialog
extends Dialog {
    private static final int SIZING_TEXT_WIDTH = 600;
    private static final int SIZING_TEXT_HEIGHT = 400;
    private Collection<Throwable> errors;
    private Image image;
    private Text text;

    TestErrorsDialog(Shell parent, Image image, Collection<Throwable> errors) {
        super(parent);
        this.image = image;
        this.errors = errors;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Connection Diagnostic errors");
        shell.setImage(this.image);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "&OK", true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setSize(composite.computeSize(-1, -1));
        Label label = new Label(composite, 64);
        label.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        label.setText("Connection diagnostics ended with errors:");
        this.text = new Text(composite, 2818);
        this.text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.text.setEditable(false);
        this.text.setText(this.createText());
        GridData data = new GridData(1808);
        data.widthHint = 600;
        data.heightHint = 400;
        this.text.setLayoutData((Object)data);
        return composite;
    }

    private String createText() {
        StringWriter buf = new StringWriter();
        PrintWriter pwr = new PrintWriter(buf);
        Iterator<Throwable> i = this.errors.iterator();
        while (i.hasNext()) {
            i.next().printStackTrace(pwr);
            pwr.println();
        }
        pwr.flush();
        return buf.toString();
    }
}

